<div class="cartItem flex space-x-4 md:space-x-6 w-full py-6 border-b border-[#EBEBEB]">
    <!-- Product Image -->
    <div>
        <div class="relative">
            <div class="px-1 absolute z-10 -top-2.5 -right-2.5 w-auto min-w-5 h-5 bg-(--theme-color) rounded-full flex justify-center items-center text-[10px] font-normal leading-[165%] text-(--theme-white)">
                <?php echo esc_html(__('1', 'tusenrosor')); ?>
            </div>
            <a href="#"
                class="w-[74px] h-[74px] min-w-[74px] md:w-[122px] md:min-w-[122px] md:h-[122px] border border-[#EBEBEB] inline-block duration-400 hover:opacity-65 in-[.sideDrawer]:border-0">
                <img
                    class="w-full h-full object-cover object-center bg-(--theme-white)"
                    src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/products-img/' . $product['img']); ?>"
                    alt="Cart Product Image">
            </a>
        </div>
    </div>

    <!-- Product Info -->
    <div class="w-full font-normal leading-[165%] space-y-3">
        <div class="text-sm space-y-2">
            <div class="space-y-1">
                <a href="#" class="inline-block duration-400 hover:opacity-65 w-full">
                    <h2>
                        <?php echo esc_html($product['title']); ?>
                    </h2>
                </a>
                <div class="text-(--sub-text) flex space-x-3">
                    <div>
                        <?php echo esc_html($product['price']); ?>
                    </div>
                </div>
            </div>
            <div class="text-[10px] text-(--sub-text) uppercase">
                <?php echo esc_html(__('Svart / Röd', 'tusenrosor')); ?>
            </div>
        </div>



        <?php if (!empty($product['optional'])): ?>
            <!-- 🧩 Optional Products -->
            <div class="space-y-3">
                <!-- Optional Product #1 -->
                <div class="relative w-full">
                    <a href="#" class="absolute top-1/2 -translate-y-1/2 -left-[18px] w-3 min-w-3 h-3 flex justify-center items-center bg-(--theme-color) text-(--theme-color) rounded-full">
                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect width="12" height="12" rx="6" fill="currentColor" />
                            <path d="M6 3V9M3 6H9" stroke="white" />
                        </svg>
                    </a>
                    <div class="flex items-stretch leading-0 w-full">
                        <img
                            class="w-11.5 min-w-11.5 min-h-11.5 object-cover object-center"
                            src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/products-img/blog9.webp'); ?>"
                            alt="Cart Image">

                        <div class="w-full flex items-center justify-between space-x-3 ps-3 py-[5px] bg-(--theme-white)">
                            <div class="w-full leading-[165%] flex flex-col">
                                <p class="text-xs text-(--theme-color) line-clamp-1">
                                    <?php echo esc_html(__('Gör gåvan speciell med en present överraskning.', 'tusenrosor')); ?>
                                </p>
                                <div class="text-[10px] text-(--sub-text) leading-[165%]">
                                    <?php echo esc_html(__('200 kr', 'tusenrosor')); ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Optional Product #2 -->
                <div class="relative w-full cursor-pointer modalOpenBtn">
                    <a href="#" class="absolute top-1/2 -translate-y-1/2 -left-[18px] w-3 min-w-3 h-3 flex justify-center items-center bg-(--theme-color) text-(--theme-color) rounded-full">
                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect width="12" height="12" rx="6" fill="currentColor" />
                            <path d="M6 3V9M3 6H9" stroke="white" />
                        </svg>
                    </a>
                    <div class="leading-[165%] w-full text-xs text-(--theme-color) [&_strong]:font-bold [&_strong]:text-(--sub-text)">
                        <strong>Meddelande:</strong> Rosor är utan tvekan en av världens mest älskade blommor. De har prytt våra trädgårdar, h...
                        <a href="#" class="text-xs text-(--theme-color) underline duration-400 hover:opacity-65 inline-block">
                            <?php echo esc_html(__('Ändra', 'tusenrosor')); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>