<?php
if (!empty($banner_bottom_section)) {
    foreach ($banner_bottom_section as $item) : ?>
        <a href="<?php echo esc_attr($item['page_link']); ?>" class="sliderItem text-center hover:opacity-65 md:flex flex-col items-center justify-center md:w-[calc(50%-16px)] lg:w-full lg:flex-1 duration-700">
            <?php echo wp_get_attachment_image($item['icon'], 'full', false, [
                'class' => 'max-w-6 mb-3 mx-auto object-contain',
                'alt' => 'Slider Image'
            ]);
            ?>
            <h6 class="uppercase text-xs font-medium leading-[150%]">
                <?php echo esc_html($item['title']); ?>
            </h6>
        </a>
    <?php endforeach; ?>
<?php } ?>