<?php
$header_top_search = get_theme_option_data('header_top_search');
$defaultsearchKeyword = $header_top_search['default_keyword'];
$product_ids = $header_top_search['default_product'];
$arrayDefaultKeyword = ($defaultsearchKeyword) ? explode(',', $defaultsearchKeyword) : array();

?>
<div id="searchDrawer"
    class="tusenrosorTopDrawer fixed top-0 left-0 right-0 z-40 xl:z-19 w-full transition-transform -translate-y-full bg-(--theme-white) border-t border-[#EBEBEB] duration-400"
    tabindex="-1" aria-labelledby="drawer-top-label">
    <div class="container">
        <div class="flex justify-between">
            <div class="w-full relative">
                <div class="absolute top-1/2 left-0 -translate-y-1/2">
                    <img class="max-w-6 object-contain"
                        src="<?php echo get_template_directory_uri(); ?>/assets/images/searchIcon.svg"
                        alt="Tusenrosor Icon">
                </div>

                <input
                    class="relative z-1 h-15.5 p-1 pl-12 border-0 w-full text-base md:text-sm text-(--theme-color) placeholder:text-(--theme-color) focus:outline-none appearance-none outline-0"
                    type="text" name="s" id="searchInput"
                    placeholder="<?php echo esc_html(__('Sök', 'tusenrosor')); ?>">

            </div>
            <button type="button" data-drawer-hide="searchDrawer" aria-controls="searchDrawer"
                class="hover:opacity-65 duration-400 bg-transparent p-0 border-0 flex items-center justify-center cursor-pointer relative pl-4 h-full min-h-15.5">
                <span class="h-6 w-6 min-w-6 flex items-center justify-center">
                    <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                    </svg>
                    <span class="sr-only"><?php echo esc_html(__('Close menu', 'tusenrosor')); ?></span>
                </span>
            </button>
        </div>
        <div class="pb-12 pt-4">
            <div
                class="overflow-auto hide-scrollbar max-h-[77vh] flex w-full flex-col xl:flex-row space-y-1 md:space-y-3 xl:space-y-0 xl:space-x-10">
                <div class="w-full xl:w-[247px] xl-min-w[247px] leading-[165%] font-normal">
                    <div class="mb-6 md:mb-8 border-b border-[#EBEBEB]">
                        <span class="py-3 uppercase text-(--sub-text) text-xs inline-block">
                            <?php echo esc_html(__('FÖRSLAG', 'tusenrosor')); ?>
                        </span>
                    </div>
                    <div class="lg:overflow-auto hide-scrollbar lg:max-h-[70vh]">
                        <div class="space-x-5 xl:space-x-0 space-y-5 flex xl:flex-col flex-wrap text-sm text-(--theme-color)"
                            id="default_keyword">
                            <?php
                            // Example array of link

                            // Or if you just want 24 repeated items


                            foreach ($arrayDefaultKeyword as $keyword) : ?>
                                <a class="duration-400 hover:opacity-65 searchKeyword"
                                    href="<?php echo wc_get_page_permalink('shop') . '?s=' . $keyword; ?>">
                                    <?php echo $keyword; ?>
                                    <!-- <strong class="font-semibold">Classic</strong> White Box -->
                                </a>
                            <?php endforeach; ?>

                        </div>
                    </div>
                </div>
                <div class="w-full">
                    <div class="mb-6 md:mb-8 border-b border-[#EBEBEB]">
                        <span
                            class="py-3 uppercase text-(--theme-color) text-xs border-b border-(--theme-color) inline-block">
                            <?php echo esc_html(__('PRODUKTER', 'tusenrosor')); ?>
                        </span>
                    </div>
                    <div class="lg:overflow-auto hide-scrollbar lg:max-h-[70vh]">
                        <div class="">
                            <div class="flex-col lg:flex-row flex flex-wrap lg:items-center lg:justify-center -m-1.5"
                                id="product_grid">


                                <?php foreach ($product_ids as $product_id) :


                                    $product = wc_get_product($product_id);
                                    if (! $product || ! $product->is_visible()) {
                                        continue;
                                    }

                                    // Make the product available to wc_get_template_part()
                                    global $product;
                                    $product = wc_get_product($product_id);

                                    // Load WooCommerce default content-product.php
                                    wc_get_template_part('content', 'product');
                                    wp_reset_postdata();

                                ?>
                                <?php endforeach; ?>
                            </div>
                            <div class="text-center mt-6 md:mt-8">
                                <a class="py-3.5 px-7 uppercase text-(--theme-color) bg-[#E4D3D9] text-sm inline-block font-medium cursor-pointer hover:opacity-65 duration-400 leading-5 tracking-[18%]"  data-base="<?php echo esc_url( wc_get_page_permalink('shop') ); ?>" id="searchLink"
                                    href="<?php echo wc_get_page_permalink('shop'); ?>">
                                    <?php echo esc_html(__('VISA ALLA RESULTAT', 'tusenrosor')); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>