<?php
// Ensure WooCommerce cart is loaded
if (function_exists('WC') && WC()->cart) :
    $cart          = WC()->cart;
    $cart_count    = $cart->get_cart_contents_count();
    $cart_subtotal = $cart->get_cart_subtotal(); // formatted
    $shipping_total = $cart->get_cart_shipping_total();
    $cart_total    = $cart->get_total(); // formatted
?>
    <div class="space-y-5 font-normal leading-[165%] text-(--theme-color)" id="checkoutTotal">

        <input
            name=""
            id=""
            type="text"
            placeholder="Rabattkod eller presentkort"
            class="w-full border border-[#EBEBEB] min-h-12 px-4 py-1 text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white">
        <button
            disabled
            class="uppercase min-h-12 px-3 p-1 min-w-32 text-white bg-(--theme-dark) flex items-center justify-center text-sm cursor-pointer hover:opacity-65 duration-400 disabled:opacity-30 disabled:cursor-default">
            <?php echo esc_html(__('Använd', 'tusenrosor')); ?>
        </button>

        <div class="space-y-3 text-sm">
            <div class="flex justify-between items-center space-x-1">
                <p>
                    <?php echo esc_html(__('Delsumma · 3 artiklar', 'tusenrosor')); ?>
                </p>
                <span>
                    <?php echo esc_html(__('6,207 kr', 'tusenrosor')); ?>
                </span>
            </div>
            <div class="flex justify-between items-center space-x-1">
                <p>
                    <?php echo esc_html(__('Frakt', 'tusenrosor')); ?>
                </p>
                <span>
                    <?php echo esc_html(__('GRATIS', 'tusenrosor')); ?>
                </span>
            </div>
        </div>
        <div class="flex justify-between items-center space-x-1 text-lg">
            <div>
                <?php echo esc_html(__('Totalt', 'tusenrosor')); ?>
            </div>
            <div class="space-x-2 flex items-center">
                <div class="text-xs text-(--sub-text) uppercase leading-[165%]">
                    <?php echo esc_html(__('SEK', 'tusenrosor')); ?>
                </div>
                <div>
                    <?php echo esc_html(__('6,207 kr', 'tusenrosor')); ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>