<section class="in-[.home]:bg-(--theme-white) pt-6 pb-5 md:py-8">
    <div class="container">
        <div class="hidden md:flex md:flex-wrap lg:flex-nowrap justify-center md:gap-8 lg:gap-12">
            <!-- For Desktop and tablet -->
            <?php
            require get_template_directory() . '/inc/home/home-second-section-slider.php';
            ?>
        </div>
        <div class="md:hidden relative w-full sliderPart">
            <div class="relative min-h-[54px] overflow-hidden bannerBottomSlider">
                <!-- For Mobile -->
                <?php
                require get_template_directory() . '/inc/home/home-second-section-slider.php';
                ?>
            </div>
            <div class="flex mt-1 items-center justify-center space-x-1 rtl:space-x-reverse">
                <?php if (!empty($banner_bottom_section)) {
                    foreach ($banner_bottom_section as $key => $slider) {
                ?>
                        <button type="button" class="w-4 h-4 flex items-center justify-center sliderDot cursor-pointer aria-current:opacity-100 group active" aria-current="true" data-carousel-slide-to="<?php echo $key; ?>">
                            <div class="w-1.5 h-1.5 bg-black rounded-full">
                            </div>
                        </button>

                    <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<script>
    jQuery(document).ready(function() {
        // Check if .sliderPart exists on the page
        if (jQuery('.sliderPart').length) {
            // Initial setup
            var currentIndex = 0;
            var totalSlides = jQuery('.sliderPart .sliderItem').length; // Target sliderItems within .sliderPart only

            // Initially set first item as visible and first dot as active
            jQuery('.sliderPart .sliderItem').eq(currentIndex).addClass('active').show(); // Show the first item
            jQuery('.sliderPart .sliderDot').eq(currentIndex).attr('aria-current', 'true').addClass('active opacity-100').removeClass('opacity-40'); // First dot active

            // Auto-slide functionality (every 5 seconds)
            var autoSlide = setInterval(function() {
                nextSlide();
            }, 5000);

            // Function to change the slider to the next slide
            function nextSlide() {
                currentIndex = (currentIndex + 1) % totalSlides;
                updateSlider();
            }

            // Function to change the slider to the previous slide
            function prevSlide() {
                currentIndex = (currentIndex - 1 + totalSlides) % totalSlides;
                updateSlider();
            }

            // Function to update the slider position and dots
            function updateSlider() {
                // Hide all slider items inside .sliderPart and remove the active class
                jQuery('.sliderPart .sliderItem').removeClass('active').hide();
                // Show the current slider item and add the active class
                jQuery('.sliderPart .sliderItem').eq(currentIndex).addClass('active').fadeIn(700); // Show current item

                // Update aria-current and active class on dots inside .sliderPart
                jQuery('.sliderPart .sliderDot').each(function() {
                    if (jQuery(this).data('carousel-slide-to') == currentIndex) {
                        jQuery(this).attr('aria-current', 'true').addClass('active opacity-100').removeClass('opacity-40');
                    } else {
                        jQuery(this).attr('aria-current', 'false').removeClass('opacity-100 active').addClass('opacity-40');
                    }
                });
            }

            // When a dot inside .sliderPart is clicked
            jQuery('.sliderPart .sliderDot').on('click', function() {
                clearInterval(autoSlide); // Stop auto-slide when manually clicked
                currentIndex = jQuery(this).data('carousel-slide-to');
                updateSlider();
            });

            // Swipe functionality for mobile inside .sliderPart
            var touchStartX = 0;
            var touchEndX = 0;

            jQuery('.sliderPart').on('touchstart', function(e) {
                touchStartX = e.changedTouches[0].screenX;
            });

            jQuery('.sliderPart').on('touchend', function(e) {
                touchEndX = e.changedTouches[0].screenX;
                handleSwipe();
            });

            function handleSwipe() {
                if (touchEndX < touchStartX) {
                    nextSlide(); // Swipe left -> next slide
                }
                if (touchEndX > touchStartX) {
                    prevSlide(); // Swipe right -> previous slide
                }
            }

            // Initial update of the slider
            updateSlider();
        }
    });
</script>