<!-- Include accordion item -->

<div class="accordion-item">
    <h2 id="tusenrosorFaq-heading-<?php echo esc_html($section_id . '-' . $itemkey); ?>">
        <button type="button"
            class="flex items-center justify-between gap-4 text-start w-full py-6 border-b border-[#EBEBEB] cursor-pointer outline-0"
            data-accordion-target="#tusenrosorFaq-body-<?php echo esc_html($section_id . '-' . $itemkey); ?>"
            aria-expanded="<?php echo esc_html($ariaExpanded); ?>"
            aria-controls="tusenrosorFaq-body-<?php echo esc_html($section_id . '-' . $itemkey); ?>">
            <span class="text-base font-semibold leading-[165%]">
                <?php echo esc_html($title); ?>
            </span>

            <!-- Include accordion arrows -->
            <?php
            require get_template_directory() . '/inc/common-sections/accordian-arrow.php';
            ?>
        </button>
    </h2>

    <div
        id="tusenrosorFaq-body-<?php echo esc_html($section_id . '-' . $itemkey); ?>"
        class="hidden pb-6 border-b border-[#EBEBEB]"
        aria-labelledby="tusenrosorFaq-heading-<?php echo esc_html($section_id . '-' . $itemkey); ?>">
        <div class="text-sm font-normal leading-[165%]">
            <?php echo esc_html($description); ?>
        </div>
    </div>
</div>