<!-- tusenrosorBreadcrumbs -->
<?php
$post_id=get_the_ID();

    $breadcrumbsInfo = [
        'subTitle' => get_field('subtitle'),
        'title'    => get_the_title(),
    ];

$thumbnail_id  = get_post_thumbnail_id($post_id);
$thumbnail_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'full') :'';
if(!$thumbnail_url){
    $thumbnail_url=get_template_directory_uri().'/assets/images/contactUs/contactUsBanner.webp';
}
?>
<section class="bg-cover bg-no-repeat bg-center"
    style="background-image: url('<?php echo $thumbnail_url; ?>');">
    <div class="bg-black/50 min-h-[175px] p-4 flex items-center justify-center">
        <div class="w-full text-white text-center space-y-3 md:space-y-5 font-normal tracking-[18%] uppercase">

            <?php if (!empty($breadcrumbsInfo['subTitle'])) : ?>
                <h5 class="text-[10px] md:text-xs leading-[130%] md:leading-[165%]">
                    <?php echo esc_html($breadcrumbsInfo['subTitle']); ?>
                </h5>
            <?php endif; ?>

            <?php if (!empty($breadcrumbsInfo['title'])) : ?>
                <h1 class="text-xl md:text-[28px] leading-[140%]">
                    <?php echo esc_html($breadcrumbsInfo['title']); ?>
                </h1>
            <?php endif; ?>

        </div>
    </div>
</section>