<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package tusenrosor-encoderit
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">

  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
  <?php
  $general_setting = get_theme_option_data('general_setting');
  $header_sections = get_theme_option_data('header_mega_menu');
  if ($header_sections['single_item_menu']) {
    $detailsPage = get_post_details_by_id($header_sections['single_item_menu']);
    $featureimageid = $detailsPage['thumbnail_id'];
  }
  $mega_menu_column_1_title = get_theme_option_data('column_1_title');
  $mega_menu_column_2_title = get_theme_option_data('column_2_title');
  $mega_menu_column_3_title = get_theme_option_data('column_3_title');
  $mega_menu_column_1_pages = get_theme_option_repeater_values('column_1_pages_link');

  $mega_menu_column_2_pages = get_theme_option_repeater_values('column_2_pages_link');
  $mega_menu_column_3_pages = get_theme_option_repeater_values('column_3_pages_link');
  $main_menu_array = wp_get_menu_top_menu_1_array('main-menu');

  ?>
  <?php wp_body_open(); ?>
  <div id="page" class="site">

    <!-- Include Meddelande Modal -->
    <?php require get_template_directory() . '/inc/common-sections/meddelande-modal.php'; ?>

    <!-- Include Full Page Loader -->
    <?php require get_template_directory() . '/inc/common-sections/full-page-loader.php'; ?>

    <!-- Mega menu dropdown -->
    <?php
    require get_template_directory() . '/inc/header-part/desktop-mega-menu.php';
    ?>
    <?php
    require get_template_directory() . '/inc/header-part/mobile-mega-menu.php';
    ?>

    <!-- Side Cart -->
    <div id="sideCartDrawer" class="sideDrawer cartSection fixed top-0 right-0 z-40 bottom-0 transition-transform translate-x-full bg-white w-full max-w-[375px] md:max-w-[514px] duration-400 flex flex-col" tabindex="-1" aria-labelledby="drawer-right-label">

      <div class="drawer-header px-4 py-5 md:px-8 md:py-4.5 border-b border-[#EBEBEB] flex justify-between items-center">
        <h5 class="uppercase text-base md:text-lg text-(--theme-color) font-normal leading-[140%]">
          <?php echo esc_html(__('Vagn', 'tusenrosor')); ?>
        </h5>
        <button class="hover:opacity-65 duration-400 bg-transparent p-0 border-0 h-6 w-6 flex items-center justify-center cursor-pointer relative" type="button" data-drawer-hide="sideCartDrawer" aria-controls="sideCartDrawer">
          <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
          </svg>
          <span class="sr-only"> <?php echo esc_html(__('Close menu', 'tusenrosor')); ?></span>
        </button>
      </div>


      <?php
      wc_get_template('cart/mini-cart.php');

      ?>


      <!-- footer -->
    </div>


    <!-- Search ( Products ) -->
    <?php
    require get_template_directory() . '/inc/header-part/search-drawer.php';
    ?>

    <header class="tusenrosorHeader sticky top-0 right-0 left-0 z-20 bg-(--theme-white)">
      <nav>
        <div class="flex flex-wrap justify-between items-center mx-auto container min-h-15.5">
          <button class="cursor-pointer flex items-center p-1 w-8 h-8 md:w-10 md:h-10 justify-center text-sm text-(--theme-color) hover:opacity-65 duration-400 rounded-lg xl:hidden" type="button" data-drawer-target="mobileDrawerMenu" data-drawer-show="mobileDrawerMenu" aria-controls="mobileDrawerMenu">
            <span class="sr-only">Show navigation</span>
            <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 17 14">
              <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M1 1h15M1 7h15M1 13h15" />
            </svg>
          </button>

          <!-- LOGO -->
          <?php
          require get_template_directory() . '/inc/header-part/header-logo.php';
          ?>

          <div class="flex md:order-2 space-x-3.5 md:space-x-5 rtl:space-x-reverse">
            <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>" class="hidden hover:opacity-65 duration-400 bg-transparent p-0 border-0 h-6 w-6 md:flex items-center justify-center cursor-pointer relative">
              <img class="max-w-6 object-contain" src="<?php echo get_template_directory_uri(); ?>/assets/images/userIcon.svg" alt="Tusenrosor Icon">
            </a>
            <label for="searchInput" class="hover:opacity-65 duration-400 bg-transparent p-0 border-0 h-6 w-6 flex items-center justify-center cursor-pointer relative" type="button" data-drawer-target="searchDrawer" data-drawer-show="searchDrawer" data-drawer-placement="top" aria-controls="searchDrawer">
              <img class="max-w-6 object-contain" src="<?php echo get_template_directory_uri(); ?>/assets/images/searchIcon.svg" alt="Tusenrosor Icon">
            </label>
            <button id="cartsidebtn" class="hover:opacity-65 duration-400 bg-transparent p-0 border-0 h-6 w-6 flex items-center justify-center cursor-pointer relative" type="button" data-drawer-target="sideCartDrawer" data-drawer-show="sideCartDrawer" data-drawer-placement="right" aria-controls="sideCartDrawer">
              <span class="bg-(--theme-maroon) rounded-full h-3 min-w-3 flex items-center justify-center absolute -top-0.5 -right-0.5 text-white text-center text-[8px] font-normal py-0.5 px-1" id="cart-count">
                <?php
                $cart_count = tusenrosor_get_real_cart_count();
                if ($cart_count > 9) {
                  echo '+9';
                } else {
                  echo $cart_count;
                }
                ?>
              </span>
              <img class="max-w-6 object-contain" src="<?php echo get_template_directory_uri(); ?>/assets/images/bagIcon.svg" alt="Tusenrosor Icon">
            </button>
          </div>


          <!-- Main menu -->
          <?php
          require get_template_directory() . '/inc/header-part/main-menu.php';
          ?>
        </div>
      </nav>
    </header>

    <script>
      window.Flowbite = window.Flowbite || {};
      // Prevent Flowbite auto initialization (you handle drawers manually)
      Flowbite.autoinit = false;
    </script>
    <script>
      /**/
      jQuery(document).ready(function($) {

        // =============================
        // Common helpers
        // =============================
        const $megaMenuBtn = $('#mainMenu .megaMenuBtn');
        const $megaMenuDrawer = $('.megaDropdown'); // top drawer (hover)
        const $ALL_DRAWERS = $('.sideDrawer, .tusenrosorTopDrawer, .megaDropdown');
        const BACKDROP_SEL = 'div[drawer-backdrop]';
        let hoverTimeout;

        function ensureBackdrop(opts = {
          pointerNone: false
        }) {
          let $bd = $(BACKDROP_SEL);
          if ($bd.length === 0) {
            $bd = $('<div drawer-backdrop class="customBackdrop fixed inset-0 z-10 bg-gray-900/50 dark:bg-gray-900/80"></div>');
            $('body').append($bd);
          }
          if (opts.pointerNone) {
            $bd.addClass('pointer-events-none');
          } else {
            $bd.removeClass('pointer-events-none');
          }
          return $bd;
        }

        // Extended cleanup — removes backdrop & quick-start container
        function removeBackdrop() {
          $(BACKDROP_SEL).remove();
          $('.quick-start-container').remove();
        }

        function isTopDrawer($el) {
          return $el.hasClass('tusenrosorTopDrawer') || $el.is('#desktopDrawerMegaMenu');
        }

        function openDrawer($target, {
          useBackdrop = true,
          pointerNoneBackdrop = false
        } = {}) {
          // close others first
          $ALL_DRAWERS.filter('.transform-none').not($target).each(function() {
            closeDrawer($(this));
          });

          // show target
          if (isTopDrawer($target)) {
            $target.removeClass('-translate-y-full').addClass('transform-none');
          } else {
            $target.removeClass('-translate-x-full').addClass('transform-none');
          }

          if (useBackdrop) {
            ensureBackdrop({
              pointerNone: pointerNoneBackdrop
            });
          }

          // ✅ Always keep header above overlay
          $('.tusenrosorHeader').addClass('z-20');

          updateHeaderZ();
        }

        function closeDrawer($target) {
          if (!$target || $target.length === 0) return;

          $target.removeClass('transform-none');

          if (isTopDrawer($target)) {
            $target.addClass('-translate-y-full');
          } else {
            $target.addClass('-translate-x-full');
          }

          // If no drawers remain open, remove backdrop and keep header z-20
          if ($ALL_DRAWERS.filter('.transform-none').not($target).length === 0) {
            removeBackdrop();
            $('.tusenrosorHeader').addClass('z-20');
            $megaMenuDrawer.removeClass('z-19');
          }
          updateHeaderZ();
        }

        // =============================
        // Stable hover logic for Mega Menu
        // =============================
        const $hoverArea = $megaMenuBtn.add($megaMenuDrawer);

        $hoverArea.on('mouseenter', function() {
          clearTimeout(hoverTimeout);
          openDrawer($megaMenuDrawer, {
            useBackdrop: true,
            pointerNoneBackdrop: true
          });

          // Adjust z-index layering for header vs megamenu
          $('.tusenrosorHeader').addClass('z-20');
          $megaMenuDrawer.addClass('z-19');
        });

        $hoverArea.on('mouseleave', function() {
          clearTimeout(hoverTimeout);
          hoverTimeout = setTimeout(function() {
            closeDrawer($megaMenuDrawer);
            removeBackdrop(); // remove hover-only backdrop and quick-start-container
            // Restore header/mega menu classes
            $('.tusenrosorHeader').addClass('z-20');
            $megaMenuDrawer.removeClass('z-19');
          }, 250);
        });

        // =============================
        // Update Header Z-Index for all drawers
        // =============================
        function updateHeaderZ() {
          const anyOpen = $ALL_DRAWERS.filter('.transform-none').length > 0;
          const $header = $('.tusenrosorHeader');
          const topOpen = $megaMenuDrawer.hasClass('transform-none');
          const $backdrop = $(BACKDROP_SEL);

          // ✅ Always keep header above overlay
          $header.addClass('z-20');

          // Mega menu below header when open
          if (topOpen) {
            $megaMenuDrawer.addClass('z-19');
          } else {
            $megaMenuDrawer.removeClass('z-19');
          }

          // ✅ Backdrop layering logic — only when tusenrosorTopDrawer open
          if ($backdrop.length) {
            const topDrawerOpen = $('.tusenrosorTopDrawer.transform-none').length > 0;

            if (topDrawerOpen) {
              // only then make backdrop z-10
              $backdrop.removeClass('z-30 z-40 z-50').addClass('z-10');
            } else {
              // reset to Flowbite default z-index (remove our custom)
              $backdrop.removeClass('z-10');
            }
          }
        }



        // Initial pass
        updateHeaderZ();

        // =============================
        // Flowbite Drawer Toggle Integration (click drawers)
        // =============================
        $(document).on('click', '[data-drawer-target]', function() {
          // Ensure the target drawer is selected correctly using $(this)
          const targetDrawerId = $(this).attr('data-drawer-target');
          const $targetDrawer = $('#' + targetDrawerId); // Use the ID of the drawer

          console.log($targetDrawer); // Log to check if the target drawer is found

          // Check if the target drawer exists before proceeding
          if ($targetDrawer.length > 0) {
            // Open the drawer
            openDrawer($targetDrawer, {
              useBackdrop: true,
              pointerNoneBackdrop: false
            });
          } else {
            console.log("Target drawer not found.");
          }
        });
        // $(document).on('click', '[data-custom-drawer-target]', function() {
        //   const targetId = $(this).attr('data-drawer-target');
        //   const $target = $('#' + targetId);
        //   openDrawer($target, {
        //     useBackdrop: true
        //   });
        // });
        // Fix: handle Flowbite close buttons properly
        $(document).on('keydown', function(e) {
          if (e.key === 'Escape') {
            const $openDrawers = $('.sideDrawer.transform-none, .tusenrosorTopDrawer.transform-none, .megaDropdown.transform-none');
            if ($openDrawers.length) {
              $openDrawers.each(function() {
                closeDrawer($(this));
              });
              removeBackdrop();
            }
          }
        });

        $(document).on('click', '[data-drawer-hide]', function() {
          setTimeout(function() {
            removeBackdrop(); // removes quick-start-container too
            $('.tusenrosorHeader').addClass('z-20');
            $megaMenuDrawer.removeClass('z-19');
            updateHeaderZ();
          }, 300);
        });
        $(document).on('click', function(e) {
          // If click is inside any open drawer → ignore
          if ($(e.target).closest(BACKDROP_SEL).length) return;
          console.log('close');
          // If there’s an open drawer and click is outside → close all
          const $openDrawers = $(BACKDROP_SEL + '.transform-none');
          if ($openDrawers.length) {
            $openDrawers.each(function() {
              closeDrawer($(this));
            });
            removeBackdrop();
          }
        });
        // Click backdrop to close any open drawer
        $(document).on('click', BACKDROP_SEL, function() {
          $ALL_DRAWERS.filter('.transform-none').each(function() {
            closeDrawer($(this));
            const $drawer = $(this);
            if ($drawer.hasClass('transform-none')) {
              closeDrawer($drawer);
            }
            console.log($drawer);
          });

          removeBackdrop();
          $('.tusenrosorHeader').addClass('z-20');
          $megaMenuDrawer.removeClass('z-19');
          updateHeaderZ();
        });

        // Observe class changes dynamically for all sideDrawers
        $ALL_DRAWERS.each(function() {
          const drawer = this;
          new MutationObserver(updateHeaderZ).observe(drawer, {
            attributes: true,
            attributeFilter: ['class']
          });
        });



      });
    </script>