<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package tusenrosor-encoderit
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">

  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

  <!-- Include Meddelande Modal -->
  <?php require get_template_directory() . '/inc/common-sections/meddelande-modal.php'; ?>

  <!-- Include Full Page Loader -->
  <?php require get_template_directory() . '/inc/common-sections/full-page-loader.php'; ?>