<?php
$footer_sections = get_theme_option_data('footer_section');

$social_links = get_theme_option_repeater_values('social_links');
$support_cards = get_theme_option_repeater_values('support_cards');
$crm_api_data = get_theme_option_data('crm_api_data');


?>
<footer class="tusenrosorFooter bg-(--theme-dark) text-white/65 font-normal text-sm leading-[165%]">
	<div class="pt-12 pb-8">
		<div class="container">
			<div class="mx-auto max-w-[500px]">
				<div class="text-white text-center">
					<h2 class="text-xl md:text-[28px] uppercase leading-[140%] tracking-[0.18em] m-0">
						<?php if (isset($footer_sections['subscribe_form_title'])) echo $footer_sections['subscribe_form_title']; ?>
					</h2>
					<p class="mt-5">
						<?php if (isset($footer_sections['subscription_form_description'])) echo $footer_sections['subscription_form_description']; ?>
					</p>
				</div>
				<div class="pt-8 text-center">
					<form id="footerForm" class="w-full" method="post">
						<div class="position-relative">
							<input type="hidden" name="action" value="custom_subscription_form">
							<?php wp_nonce_field('subscription_form', 'subscription_nonce'); ?>
							<div class="flex flex-col md:flex-row items-stretch md:space-x-4 space-y-4 md:space-y-0">
								<input
									type="email"
									class="text-base md:text-sm w-full bg-(--theme-dark) border border-[#EBEBEB] rounded-none px-4 py-1 min-h-12 box-border outline-0 
									placeholder:text-white/65 text-white focus:text-white focus:border-white focus:outline-none transition-colors duration-400
									"
									placeholder="E-post" name="subscriber_email" required>
								<button
									class="w-full md:w-auto text-sm text-uppercase bg-white text-(--theme-dark) text-nowrap py-1 px-7 min-h-12 flex items-center justify-center box-border cursor-pointer duration-400 hover:opacity-65"
									type="submit">
									<?php echo esc_html(__('FA DIN KOD', 'tusenrosor')); ?>
								</button>
							</div>
							<div id="footer_submit_message_print"></div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>

	<div class="pt-8 pb-12">
		<div class="container">
			<div class="flex justify-between flex-wrap">
				<!-- Column 1: Logo / Info -->
				<div class="mx-auto lg:mx-0 w-full lg:w-[29.76%] lg:min-w-[260px] mb-16 lg:mb-0">
					<div class="max-w-[400px] md:max-w-auto mx-auto lg:mx-0 flex flex-col h-full">
						<div class="mb-6 text-center lg:text-start">
							<a class="mb-6 inline-block mx-auto lg:mx-0" href="<?php echo site_url(); ?>">

								<?php if (isset($footer_sections['footer_logo']) && $footer_sections['footer_logo']) {
									echo wp_get_attachment_image($footer_sections['footer_logo'], 'full', false, [
										'class' => 'max-w-38 object-contain',
										'alt' => 'Footer Image'
									]);

								?>
								<?php } ?>
							</a>
							<p>
								<?php if (isset($footer_sections['footer_description'])) echo $footer_sections['footer_description']; ?>
							</p>
						</div>
						<?php if (!empty($social_links)) { ?>
							<div class="flex justify-center lg:justify-start items-center space-x-5 lg:mt-auto">
								<?php foreach ($social_links as $social) {  ?>
									<a href="<?php echo $social['link'] ?>" target="_blank">

										<?php echo wp_get_attachment_image($social['image'], 'full', false, [
											'class' => 'w-5 h-5 object-contain',
											'alt' => 'Social Image'
										]);
										?>
									</a>
								<?php } ?>

							</div>
						<?php } ?>

					</div>
				</div>
				<?php

				$locations = get_nav_menu_locations();
				$menu_id   = $locations['store_links'] ?? null;

				// If using WPML, this ensures we fetch the correct translated menu
				if (function_exists('wpml_object_id') && $menu_id) {
					$menu_id = wpml_object_id($menu_id, 'nav_menu', true);
				}

				$menu_obj  = $menu_id ? wp_get_nav_menu_object($menu_id) : null;
				$menu_name = $menu_obj ? $menu_obj->name : esc_html(__('Butik', 'tusenrosor'));
				?>
				<!-- Column 2: Butik store_links-->
				<div class="w-full md:w-[21.02%] lg:w-[11.01%] min-w-[148px] mb-12 md:mb-0">
					<?php if ($menu_name): ?>
						<h3 class="text-white text-xs font-normal uppercase tracking-[0.18em] mb-[15px]">
							<?php echo esc_html($menu_name); ?>
						</h3>
					<?php endif; ?>
					<div class="flex flex-col">

						<?php $menu_array = wp_get_menu_array('store_links');
						foreach ($menu_array as $menu) {
						?>
							<a href="<?php echo $menu['url'] ?>" class="py-[5px] hover:text-white duration-400">
								<?php echo $menu['title'] ?>
							</a>
						<?php } ?>
					</div>
				</div>

				<!-- Column 3: Användbart -->
				<?php

				$locations = get_nav_menu_locations();
				$menu_id   = $locations['footer_useful_links'] ?? null;

				// If using WPML, this ensures we fetch the correct translated menu
				if (function_exists('wpml_object_id') && $menu_id) {
					$menu_id = wpml_object_id($menu_id, 'nav_menu', true);
				}

				$menu_obj  = $menu_id ? wp_get_nav_menu_object($menu_id) : null;
				$menu_name = $menu_obj ? $menu_obj->name : esc_html(__('Användbart', 'tusenrosor'));
				?>

				<div class="w-full md:w-[14.49%] lg:w-[7.59%] min-w-[102px] mb-12 md:mb-0">
					<?php if ($menu_name): ?>
						<h3 class="text-white text-xs font-normal uppercase tracking-[0.18em] mb-[15px]">
							<?php echo esc_html($menu_name); ?>
						</h3>

					<?php endif; ?>
					<div class="flex flex-col">

						<?php $menu_array = wp_get_menu_array('footer_useful_links');
						foreach ($menu_array as $menu) {
						?>
							<a href="<?php echo $menu['url'] ?>" class="py-[5px] hover:text-white duration-400">
								<?php echo $menu['title'] ?>
							</a>
						<?php } ?>
					</div>
				</div>


				<!-- Column 4: Kundtjänst -->
				<div class="w-full md:w-[35.51%] lg:w-[22.32%] min-w-[260]">
					<h3 class="text-white text-xs font-normal uppercase tracking-[0.18em] mb-5">

						<?php echo esc_html(__('Kundtjänst', 'tusenrosor')); ?>
					</h3>
					<ul class="space-y-2.5">
						<?php if (isset($footer_sections['footer_email_text']) && $footer_sections['footer_email_text']) { ?>
							<li>
								<?php if (isset($footer_sections['footer_email_text'])) echo $footer_sections['footer_email_text']; ?>
							</li>
						<?php } ?>
						<?php if (isset($footer_sections['footer_address']) && $footer_sections['footer_address']) { ?>
							<li> <?php echo $footer_sections['footer_address']; ?></li>
						<?php } ?>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<div class="py-8 border-t border-[#292524]">
		<div class="container">
			<div class="flex flex-col lg:flex-row justify-between items-center space-x-0 lg:space-x-1.5 space-y-6 lg:space-y-0">
				<div class="flex gap-7">
					<img src="<?php echo get_template_directory_uri(); ?>/assets/images/footer/languages.png" alt="languages">
					<img src="<?php echo get_template_directory_uri(); ?>/assets/images/footer/selectOpction.png" alt="selectOpction">
				</div>
				<p class="font-light text-xs uppercase tracking-[0.18em]">
					© <?php echo date('Y'); ?> <?php if (isset($footer_sections['copy_right_text'])) echo '- ' . $footer_sections['copy_right_text']; ?>
				</p>
				<?php if (!empty($support_cards)) { ?>
					<div class="flex flex-wrap justify-center gap-4">
						<?php foreach ($support_cards as $card) { ?>
							<div class="w-[38px] h-6">
								<?php echo wp_get_attachment_image($card['icon'], 'full', false, [
									'class' => '',
									'alt' => 'Card Image'
								]);
								?>
							</div>
						<?php } ?>


					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>