jQuery(document).ready(function ($) {
    const container = $('#reviews-container');
    const loadMoreBtn = $('#load-more-review');
    const loadMoreWrapper = $('#loadmorebtnsec');
    const sortSelect = $('#review-sort');

    let page = 1;
    let order = container.data('order');
    const productID = container.data('product-id');

    function loadReviews(reset = false) {
        $.ajax({
            url: reviewsAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'load_more_reviews',
                nonce: reviewsAjax.nonce,
                product_id: productID,
                page: page,
                order: order
            },
            beforeSend: function () {
                loadMoreBtn.text(reviewsAjax.loading_text);
            },
            success: function (response) {
                if (response.success) {
                    if (reset) container.html('');
                    container.append(response.data.html);
                   loadMoreBtn.text(reviewsAjax.view_more_text);

                    if (response.data.has_more) {

                        loadMoreWrapper.removeClass('hidden');
                    } else {
                      //  alert('no');
                      loadMoreWrapper.addClass('hidden');
                    }
                } else {
                    loadMoreWrapper.addClass('hidden');
                }
            }
        });
    }

    // Initial load
    loadReviews();

    // Load more click
    loadMoreBtn.on('click', function () {
        page++;
        loadReviews();
    });

    // Sorting change
    sortSelect.on('change', function () {
        order = $(this).val();
        page = 1;
        container.data('order', order);
        loadReviews(true);
    });
});
