jQuery(document).ready(function ($) {
    // Check if the .scrollSlider elements exist before executing the script
    $('.scrollSlider').each(function () {
        const slider = $(this); // Each individual .scrollSlider element
        let isDown = false;
        let startX;
        let scrollLeft;

        // Only scroll if content is overflowing
        function canScrollHorizontally() {
            const el = slider[0];
            return el.scrollWidth > el.clientWidth;
        }

        // Drag to scroll
        slider.on('mousedown', function (e) {
            if (!canScrollHorizontally()) return;

            isDown = true;
            slider.addClass('dragging');
            startX = e.pageX - slider.offset().left;
            scrollLeft = slider.scrollLeft();
            e.preventDefault();
        });

        slider.on('mouseleave mouseup', function () {
            isDown = false;
            slider.removeClass('dragging');
        });

        slider.on('mousemove', function (e) {
            if (!isDown || !canScrollHorizontally()) return;

            const x = e.pageX - slider.offset().left;
            const walk = (x - startX) * 1.5; // scroll speed
            slider.scrollLeft(scrollLeft - walk);
        });

        // Scroll with mouse wheel
        slider.on('wheel', function (e) {
            const el = slider[0];
            if (!canScrollHorizontally()) return;

            const maxScroll = el.scrollWidth - el.clientWidth;
            const newScroll = el.scrollLeft + e.originalEvent.deltaY;

            // Only scroll if within bounds
            if (newScroll >= 0 && newScroll <= maxScroll) {
                e.preventDefault(); // prevent default page scroll
                el.scrollLeft = newScroll;
            }
        });
    });
});