jQuery(document).ready(function ($) {
  $("#custom_contact_form").on("submit", function (e) {
    e.preventDefault();

    var form = $(this);
    var recaptchaResponse = grecaptcha.getResponse();
    if (!recaptchaResponse || recaptchaResponse.length === 0) {
      alert(contactUSParam.robotAlert); // "Please confirm you're not a robot"
      return false; // stop submission
    }

    $.ajax({
      type: "POST",
      url: contactUSParam.ajax_url,
      data: form.serialize(),
      dataType: "json",
      beforeSend: function () {
        form
          .find("button[type=submit]")
          .prop("disabled", true)
          .text(contactUSParam.sending);
      },
      success: function (response) {
        if (response.success) {
          //alert(response.data.message); // ✅ success
          form[0].reset();
          $("#contact_submit_message_print").text(response.data.message);
          $("#contact_submit_message_print").removeClass("textError");
          $("#contact_submit_message_print").addClass("bgGradientSuccess");
        } else {
          //alert(response.data.message || "Något gick fel!");
          $("#contact_submit_message_print").text(response.data.message);
          $("#contact_submit_message_print").removeClass("bgGradientSuccess");
          $("#contact_submit_message_print").addClass("textError");
        }
        grecaptcha.reset();
        setTimeout(function () {
          $("#contact_submit_message_print").fadeOut("slow", function () {
            $(this).text("").show(); // Remove text and reset visibility
          });
        }, 5000);
      },
      error: function () {
        alert(contactUSParam.server_error);
        grecaptcha.reset();
      },
      complete: function () {
        form
          .find("button[type=submit]")
          .prop("disabled", false)
          .text(contactUSParam.send_button);
      },
    });
  });
  $("#footerForm").on("submit", function (e) {
    e.preventDefault();

    var form = $(this);

    $.ajax({
      type: "POST",
      url: contactUSParam.ajax_url, // Change this to your actual subscription AJAX URL if needed
      data: form.serialize(),
      dataType: "json",
      beforeSend: function () {
        // Disable the submit button while the request is being processed
        form
          .find("button[type=submit]")
          .prop("disabled", true)
          .text(contactUSParam.sending); // Customize text if needed
      },
      success: function (response) {
        if (response.success) {
          //alert(response.data.message); // Display success message
          $("#footer_submit_message_print").text(response.data.message);
          $("#footer_submit_message_print").removeClass("textError");
          $("#footer_submit_message_print").addClass("bgGradientSuccess");
          form[0].reset(); // Reset the form fields
        } else {
          $("#footer_submit_message_print").text(response.data.message);
          $("#footer_submit_message_print").removeClass("bgGradientSuccess");
          $("#footer_submit_message_print").addClass("textError");
          //alert(response.data.message || "Något gick fel!"); // Handle error
        }
        form
          .find("button[type=submit]")
          .prop("disabled", false)
          .text("Prenumerera");
        setTimeout(function () {
          $("#footer_submit_message_print").fadeOut("slow", function () {
            $(this).text("").show(); // Remove text and reset visibility
          });
        }, 5000);
      },
      error: function () {
        alert(contactUSParam.server_error); // Handle server error
      },
      complete: function () {
        // Re-enable the submit button after the request is complete
        form
          .find("button[type=submit]")
          .prop("disabled", false)
          .text(contactUSParam.subscribe_button); // Customize button text
      },
    });
  });
});
