<?php
function tusenrosor_register_menus()
{
    register_nav_menus([
        'footer_useful_links' => __('Användbart', 'tusenrosor'),
        'store_links' => __('Butik', 'tusenrosor'),
    ]);
}
add_action('after_setup_theme', 'tusenrosor_register_menus');
//hide admin bar
function show_admin_bar_forcefully()
{
    return false;
}
add_filter('show_admin_bar', 'show_admin_bar_forcefully', 999999);

//Cpt create method
if (!function_exists('register_custom_post_type_global')) {
    /**
     * Register a global reusable custom post type
     *
     * @param string $slug Post type slug
     * @param string $singular_label Singular name (for admin labels)
     * @param string|null $taxonomy Optional taxonomy name
     * @param array $args Optional arguments to override defaults
     */
    function register_custom_post_type_global($slug, $singular_label, $taxonomy = null, $args = [], $public = true)
    {
        $plural_label = $singular_label . 's';

        // 🔹 Default labels
        $labels = [
            'name'                  => _x($plural_label, 'Post Type General Name'),
            'singular_name'         => _x($singular_label, 'Post Type Singular Name'),
            'menu_name'             => __($plural_label),
            'name_admin_bar'        => __($singular_label),
            'add_new'               => __('Add New'),
            'add_new_item'          => __('Add New ' . $singular_label),
            'edit_item'             => __('Edit ' . $singular_label),
            'new_item'              => __('New ' . $singular_label),
            'view_item'             => __('View ' . $singular_label),
            'all_items'             => __('All ' . $plural_label),
            'search_items'          => __('Search ' . $plural_label),
            'not_found'             => __('No ' . strtolower($plural_label) . ' found.'),
            'not_found_in_trash'    => __('No ' . strtolower($plural_label) . ' found in Trash.'),
        ];

        // 🔹 Default args
        $defaults = [
            'labels'              => $labels,
            'public'              => $public,
            'has_archive'         => true,
            'rewrite'             => ['slug' => $slug],
            'menu_position'       => 5,
            'menu_icon'           => 'dashicons-admin-post',
            'supports'            => ['title', 'editor', 'thumbnail', 'excerpt'],
            'show_in_rest'        => true,
        ];

        // Allow overrides
        $args = wp_parse_args($args, $defaults);

        // 🔹 Register the post type
        register_post_type($slug, $args);

        // 🔹 Register taxonomy only if provided
        if (!empty($taxonomy)) {
            $tax_labels = [
                'name'              => ucfirst(str_replace('_', ' ', $taxonomy)),
                'singular_name'     => ucfirst(str_replace('_', ' ', $taxonomy)),
                'search_items'      => __('Search ' . $taxonomy),
                'all_items'         => __('All ' . $taxonomy),
                'edit_item'         => __('Edit ' . $taxonomy),
                'update_item'       => __('Update ' . $taxonomy),
                'add_new_item'      => __('Add New ' . $taxonomy),
                'new_item_name'     => __('New ' . $taxonomy),
                'menu_name'         => __(ucfirst(str_replace('_', ' ', $taxonomy))),
            ];

            register_taxonomy(
                $taxonomy,
                $slug,
                [
                    'labels'       => $tax_labels,
                    'hierarchical' => true,
                    'show_admin_column' => true,
                    'rewrite'      => ['slug' => $taxonomy],
                    'show_in_rest' => true,
                ]
            );
        }
    }
}
add_action('init', function () {
    register_custom_post_type_global('testimonial', 'Testimonial', '', '', false);

    register_custom_post_type_global('faq', 'Faq', 'faq-category');
});
//shiping method setting page
/**
 * Add "Custom Shipping Settings" page under WooCommerce menu
 */
// add_action('admin_menu', function () {
//     add_submenu_page(
//         'woocommerce',
//         __('Custom Shipping Settings', 'tusenrosor'),
//         __('Custom Shipping Settings', 'tusenrosor'),
//         'manage_woocommerce',
//         'custom-shipping-settings',
//         'tusenrosor_render_shipping_settings_page'
//     );
// });

/**
 * Register settings fields
 */
add_action('admin_init', function () {
    register_setting('tusenrosor_shipping_settings', 'tusenrosor_shipping_methods');
});
function tusenrosor_render_shipping_settings_page()
{
    $methods = get_option('tusenrosor_shipping_methods', []);

    if (!is_array($methods)) $methods = [];

?>
    <div class="wrap">
        <h1><?php _e('Custom Shipping Settings', 'tusenrosor'); ?></h1>

        <form method="post" action="options.php">
            <?php settings_fields('tusenrosor_shipping_settings'); ?>

            <table class="form-table" id="shippingMethodsTable">
                <thead>
                    <tr>
                        <th><?php _e('Method Name', 'tusenrosor'); ?></th>
                        <th><?php _e('Free Shipping (Day Range)', 'tusenrosor'); ?></th>
                        <th><?php _e('Early Delivery Fee', 'tusenrosor'); ?></th>
                        <th><?php _e('Special Day Fee (Saturday)', 'tusenrosor'); ?></th>
                        <th><?php _e('Remove', 'tusenrosor'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($methods)) : ?>
                        <?php foreach ($methods as $index => $method) : ?>
                            <tr>
                                <td><input type="text" name="tusenrosor_shipping_methods[<?php echo $index; ?>][name]" value="<?php echo esc_attr($method['name']); ?>" /></td>
                                <td><input type="text" name="tusenrosor_shipping_methods[<?php echo $index; ?>][range]" placeholder="e.g. 8" value="<?php echo esc_attr($method['range']); ?>" /></td>
                                <td><input type="number" step="0.01" name="tusenrosor_shipping_methods[<?php echo $index; ?>][early_fee]" value="<?php echo esc_attr($method['early_fee']); ?>" /></td>
                                <td><input type="number" step="0.01" name="tusenrosor_shipping_methods[<?php echo $index; ?>][special_fee]" value="<?php echo esc_attr($method['special_fee']); ?>" /></td>
                                <td><button type="button" class="button removeMethod"><?php _e('Remove', 'tusenrosor'); ?></button></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

            <p><button type="button" class="button button-secondary" id="addShippingMethod"><?php _e('Add Method', 'tusenrosor'); ?></button></p>

            <?php submit_button(); ?>
        </form>
    </div>

    <script>
        jQuery(document).ready(function($) {
            let index = <?php echo count($methods); ?>;

            $('#addShippingMethod').on('click', function() {
                const row = `
                <tr>
                    <td><input type="text" name="tusenrosor_shipping_methods[${index}][name]" placeholder="e.g. Standard Shipping" /></td>
                    <td><input type="text" name="tusenrosor_shipping_methods[${index}][range]" placeholder="e.g. 8-9" /></td>
                    <td><input type="number" step="0.01" name="tusenrosor_shipping_methods[${index}][early_fee]" value="0" /></td>
                    <td><input type="number" step="0.01" name="tusenrosor_shipping_methods[${index}][special_fee]" value="0" /></td>
                    <td><button type="button" class="button removeMethod"><?php _e('Remove', 'tusenrosor'); ?></button></td>
                </tr>`;
                $('#shippingMethodsTable tbody').append(row);
                index++;
            });

            $(document).on('click', '.removeMethod', function() {
                $(this).closest('tr').remove();
            });
        });
    </script>
<?php
}
function hide_pages_from_admin($query) {
    // Check if we are in the admin area and if this is the "pages" post type
    if (is_admin() && $query->is_main_query() && $query->get('post_type') === 'page') {

        // Get the pages by their slugs
        $excluded_pages = ['acf-repeater', 'theme-options'];

        // Initialize an empty array to store the page IDs
        $excluded_page_ids = [];

        // Loop through the slugs and get the page IDs
        foreach ($excluded_pages as $slug) {
            $page = get_page_by_path($slug);
            if ($page) {
                $excluded_page_ids[] = $page->ID; // Add the page ID to the array
            }
        }

        // If there are any pages to exclude, modify the query to exclude them
        if (!empty($excluded_page_ids)) {
            $query->set('post__not_in', array_merge($query->get('post__not_in', []), $excluded_page_ids));
        }
    }
}

add_action('pre_get_posts', 'hide_pages_from_admin');
