<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package tusenrosor-wp-theme
 */

get_header();
$content = $mega_menu_column_1_title = get_theme_option_data('404_page_content');
?>

<main id="primary" class="site-main">

	<section class="error-404 not-found py-[67px] md:py-[87px]">
		<div class="section-padding">
			<div class="container">
				<div class="max-w-[532px] mx-auto">
					<div class="text-center font-normal space-y-8">
						<div class="max-w-[343px] md:max-w-[523px] mx-auto">
							<img class="w-full object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/404/4040.webp" alt="404-image">
						</div>
						<div class="space-y-6 md:space-y-8">
							<div class="space-y-3 md:space-y-5">
								<h1 class="text-xl md:text-[28px] text-[#111116] leading-[140%] tracking-[18%] uppercase">
									<?php echo $content['title']; ?>
								</h1>
								<p class="text-sm text-[#475156] leading-[165%]"><?php echo $content['description']; ?></p>
							</div>
							<div>
								<a href="<?php echo site_url(); ?>" class="text-(--white) text-sm font-medium leading-[165%] tracking-[18%] uppercase bg-(--theme-dark) border border-(--theme-dark) py-[11.5px] px-7 inline-block duration-400 hover:opacity-65"><?php echo esc_html(__('GÅ TILL STARTSIDAN', 'tusenrosor')) ?></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section><!-- .error-404 -->

</main><!-- #main -->

<?php
get_footer();
