<?php

/**
 * Plugin Name: Mug Mockup Pro
 * Description: Customer can upload image, rotate, resize, drag; mug color change; curved wrap; save mockup.
 * Version: 1.0
 */

if (!defined('ABSPATH')) exit;

class MugMockupPro
{

    function __construct()
    {
        add_shortcode('mug_mockup_pro', [$this, 'render']);
        add_action('wp_enqueue_scripts', [$this, 'assets']);
        add_action('wp_ajax_save_mug', [$this, 'save']);
        add_action('wp_ajax_nopriv_save_mug', [$this, 'save']);
    }

    function assets()
    {

        wp_enqueue_style(
            'mug-pro-css',
            plugin_dir_url(__FILE__) . 'assets/css/designer.css'
        );

        wp_enqueue_script(
            'fabric-js',
            'https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.3.0/fabric.min.js',
            [],
            false,
            true
        );

        wp_enqueue_script(
            'mug-pro-js',
            plugin_dir_url(__FILE__) . 'assets/js/designer-pro.js',
            ['jquery', 'fabric-js'],
            false,
            true
        );

        wp_localize_script('mug-pro-js', 'MUGDATA', [
            'mug'        => plugin_dir_url(__FILE__) . 'assets/img/mug.png',
            'mask'       => plugin_dir_url(__FILE__) . 'assets/img/mug-mask.png',
            'displace'   => plugin_dir_url(__FILE__) . 'assets/img/mug-displace.png',
            'ajax'       => admin_url('admin-ajax.php'),
            'nonce'      => wp_create_nonce('mug_pro_nonce')
        ]);
    }

    function render()
    {
        ob_start(); ?>

        <div id="mugDesigner">

            <input type="file" id="uploadUserImage" accept="image/*">

            <input type="color" id="mugColor" value="#ffffff">

            <button id="alignTop">Top</button>
            <button id="alignMid">Middle</button>
            <button id="alignBottom">Bottom</button>

            <button id="flipH">Flip H</button>
            <button id="flipV">Flip V</button>

            <button id="applyCurve">Apply Curve</button>

            <button id="saveMug">Save</button>

            <canvas id="mugCanvas" width="1100" height="1100"></canvas>

        </div>


<?php return ob_get_clean();
    }

    function save()
    {
        check_ajax_referer('mug_pro_nonce', 'nonce');

        $img = $_POST['img'];
        $img = str_replace('data:image/png;base64,', '', $img);
        $img = base64_decode($img);

        $name = 'mug-' . time() . '.png';
        $upload = wp_upload_dir();
        file_put_contents($upload['path'] . '/' . $name, $img);

        wp_send_json_success($upload['url'] . '/' . $name);
    }
}

new MugMockupPro();
