jQuery(document).ready(function ($) {

    const canvas = new fabric.Canvas('mugCanvas', {
        preserveObjectStacking: true
    });

    let mugBase, maskLayer, displaceMap, userImgObj = null;

    // LOAD MUG PNG
    fabric.Image.fromURL(MUGDATA.mug, function (img) {
        mugBase = img;
        mugBase.set({
            selectable: false,
            evented: false,
            left: 0,
            top: 0
        });
        mugBase.scaleToWidth(1100);
        canvas.add(mugBase);
        canvas.sendToBack(mugBase);
    });

    // LOAD MASK PNG (for recolor only)
    fabric.Image.fromURL(MUGDATA.mask, function (img) {
        maskLayer = img;
        maskLayer.set({
            selectable: false,
            evented: false,
            globalCompositeOperation: "multiply"
        });
        maskLayer.scaleToWidth(1100);
        canvas.add(maskLayer);
    });

    // LOAD DISPLACE MAP
    fabric.Image.fromURL(MUGDATA.displace, function (img) {
        displaceMap = img;
        displaceMap.visible = false;
        displaceMap.scaleToWidth(1100);
        canvas.add(displaceMap);
    });

    // USER UPLOAD IMAGE
    $("#uploadUserImage").on("change", function () {

        const reader = new FileReader();

        reader.onload = function (ev) {

            fabric.Image.fromURL(ev.target.result, function (img) {

                userImgObj = img;

                userImgObj.set({
                    left: 380,
                    top: 350,
                    scaleX: 0.45,
                    scaleY: 0.45,
                    cornerStyle: 'circle',
                    cornerColor: '#00c3ff',
                    borderColor: '#00c3ff',
                    hasRotatingPoint: true
                });

                canvas.add(userImgObj);
                canvas.setActiveObject(userImgObj);
                canvas.renderAll();

            });

        };

        reader.readAsDataURL(this.files[0]);
    });

    // MUG COLOR CHANGE — PERFECT
    $("#mugColor").on("input", function () {

        maskLayer.filters = [
            new fabric.Image.filters.BlendColor({
                color: $(this).val(),
                mode: "multiply",
                alpha: 1
            })
        ];

        maskLayer.applyFilters();
        canvas.renderAll();
    });

    // APPLY CURVE WRAP
    $("#applyCurve").click(function () {

        if (!userImgObj) return;

        userImgObj.cloneAsImage(function (clone) {

            let warped = new fabric.Image(clone.getElement(), {
                left: userImgObj.left,
                top: userImgObj.top,
                scaleX: userImgObj.scaleX,
                scaleY: userImgObj.scaleY,
                angle: userImgObj.angle,
                flipX: userImgObj.flipX,
                flipY: userImgObj.flipY
            });

            warped.filters = [
                new fabric.Image.filters.DisplacementMap({
                    map: displaceMap.getElement(),
                    scale: 35,
                    channel: 0
                })
            ];

            warped.applyFilters();

            canvas.remove(userImgObj);
            userImgObj = warped;
            canvas.add(userImgObj);
            canvas.setActiveObject(userImgObj);

            canvas.renderAll();
        });

    });

    // ALIGNMENT
    $("#alignTop").click(function () {
        if (userImgObj) { userImgObj.top = 290; canvas.renderAll(); }
    });
    $("#alignMid").click(function () {
        if (userImgObj) { userImgObj.top = 430; canvas.renderAll(); }
    });
    $("#alignBottom").click(function () {
        if (userImgObj) { userImgObj.top = 610; canvas.renderAll(); }
    });

    // FLIP
    $("#flipH").click(function () {
        if (userImgObj) { userImgObj.flipX = !userImgObj.flipX; canvas.renderAll(); }
    });
    $("#flipV").click(function () {
        if (userImgObj) { userImgObj.flipY = !userImgObj.flipY; canvas.renderAll(); }
    });

    // SAVE FINAL IMAGE
    $("#saveMug").click(function () {

        let imgData = canvas.toDataURL("image/png");

        $.post(MUGDATA.ajax, {
            action: "save_mug",
            nonce: MUGDATA.nonce,
            img: imgData
        }, function (res) {
            alert("Saved: " + res.data);
        });

    });

});
