<?php

/**
 * Plugin Name: Mug Mockup Designer
 * Description: Create custom mug mockups with image upload, drag, resize, and background color change.
 * Version: 1.0
 * Author: ChatGPT
 */

if (!defined('ABSPATH')) exit;

class MugMockupDesigner
{

  function __construct()
  {
    add_shortcode('mug_mockup', [$this, 'render_mockup_page']);
    // THIS ONE → must be inside constructor
    add_shortcode('mug_mockup_curved', [$this, 'render_curved_mockup']);
    add_action('wp_enqueue_scripts', [$this, 'enqueue_assets']);

    add_action('wp_ajax_mug_save', [$this, 'save_mockup']);
    add_action('wp_ajax_nopriv_mug_save', [$this, 'save_mockup']);
  }

  function enqueue_assets()
  {
    wp_enqueue_style('mug-designer-css', plugin_dir_url(__FILE__) . 'assets/css/designer.css');
    wp_enqueue_script('mug-designer-js', plugin_dir_url(__FILE__) . 'assets/js/designer.js', ['jquery'], false, true);

    wp_localize_script('mug-designer-js', 'MugMockup', [
      'ajaxurl' => admin_url('admin-ajax.php'),
      'mugImage' => plugin_dir_url(__FILE__) . 'assets/img/mug.png',
      'nonce' => wp_create_nonce('mug_mockup_nonce')
    ]);
    wp_enqueue_script(
      'mug-designer-curved-js',
      plugin_dir_url(__FILE__) . 'assets/js/designer-curved.js',
      ['jquery'],
      false,
      true
    );

    wp_localize_script('mug-designer-curved-js', 'MugMockupCurved', [
      'ajaxurl' => admin_url('admin-ajax.php'),
      'mugImage' => plugin_dir_url(__FILE__) . 'assets/img/mug.png',
      'mugMask' => plugin_dir_url(__FILE__) . 'assets/img/mug-mask.png',
      'nonce' => wp_create_nonce('mug_mockup_nonce')
    ]);
  }

  function render_mockup_page()
  {
    ob_start(); ?>

    <div class="mug-designer-container">

      <h2>Mug Mockup Designer</h2>

      <div class="controls-panel">

        <label>Upload Your Image</label>
        <input type="file" id="uploadImage" accept="image/*">

        <label>Resize</label>
        <input type="range" id="resizeSlider" min="20" max="200" value="100">

        <label>Background Color</label>
        <input type="color" id="bgColor" value="#ffffff">

        <button id="saveMockup" class="save-btn">Download Mockup</button>

      </div>

      <div class="mug-preview-box">
        <canvas id="mugCanvas" width="900" height="900"></canvas>
      </div>
    </div>

  <?php return ob_get_clean();
  }

  function save_mockup()
  {
    check_ajax_referer('mug_mockup_nonce', 'nonce');

    if (empty($_POST['image'])) {
      wp_send_json_error("Missing image data.");
    }

    $img = $_POST['image'];
    $img = str_replace('data:image/png;base64,', '', $img);
    $img = base64_decode($img);

    $filename = 'mug-mockup-' . time() . '.png';
    $upload_dir = wp_upload_dir();
    $file_path = $upload_dir['path'] . '/' . $filename;

    file_put_contents($file_path, $img);

    wp_send_json_success($upload_dir['url'] . '/' . $filename);
  }
  function render_curved_mockup()
  {

    ob_start(); ?>

    <div class="mug-designer-container curved">

      <h2>Mug Curved Mockup Designer</h2>

      <div class="controls-panel">

        <label>Upload Design</label>
        <input type="file" id="uploadImageCurved" accept="image/*">

        <label>Curvature Strength</label>
        <input type="range" min="0" max="60" value="25" id="curveRange">

        <label>Design Size</label>
        <input type="range" min="20" max="200" value="100" id="curvedResize">

        <label>Mug Background Color</label>
        <input type="color" id="mugColor" value="#ffffff">

        <label>Alignment</label>
        <button class="align-btn" data-align="top">Top</button>
        <button class="align-btn" data-align="middle">Middle</button>
        <button class="align-btn" data-align="bottom">Bottom</button>

        <label>Flip</label>
        <button id="flipH">Horizontal</button>
        <button id="flipV">Vertical</button>

        <button id="saveCurved" class="save-btn">Download</button>
      </div>

      <div class="mug-preview-box">
        <canvas id="mugCanvasCurved" width="900" height="900"></canvas>
      </div>
    </div>

<?php return ob_get_clean();
  }
}

new MugMockupDesigner();
