jQuery(document).ready(function ($) {

    const canvas = document.getElementById("mugCanvas");
    const ctx = canvas.getContext("2d");

    let mugImg = new Image();
    mugImg.src = MugMockup.mugImage;

    let userImg = null;
    let userX = 320;
    let userY = 260;
    let userSize = 300;

    mugImg.onload = drawCanvas;

    function drawCanvas() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        // Background color
        ctx.fillStyle = $("#bgColor").val();
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        // Mug
        ctx.drawImage(mugImg, 0, 0, canvas.width, canvas.height);

        // User Image
        if (userImg) {
            ctx.drawImage(userImg, userX, userY, userSize, userSize);
        }
    }

    // Upload image
    $("#uploadImage").on("change", function (e) {
        const reader = new FileReader();
        reader.onload = function (event) {
            userImg = new Image();
            userImg.onload = drawCanvas;
            userImg.src = event.target.result;
        };
        reader.readAsDataURL(this.files[0]);
    });

    // Resize
    $("#resizeSlider").on("input", function () {
        userSize = parseInt($(this).val()) * 3;
        drawCanvas();
    });

    // Background Change
    $("#bgColor").on("input", drawCanvas);

    // Drag movement
    let dragging = false;

    canvas.addEventListener("mousedown", (e) => {
        if (!userImg) return;

        let rect = canvas.getBoundingClientRect();
        let x = e.clientX - rect.left;
        let y = e.clientY - rect.top;

        if (x >= userX && x <= userX + userSize && y >= userY && y <= userY + userSize) {
            dragging = true;
        }
    });

    canvas.addEventListener("mousemove", (e) => {
        if (!dragging) return;

        let rect = canvas.getBoundingClientRect();
        userX = e.clientX - rect.left - userSize / 2;
        userY = e.clientY - rect.top - userSize / 2;

        drawCanvas();
    });

    canvas.addEventListener("mouseup", () => dragging = false);
    canvas.addEventListener("mouseleave", () => dragging = false);

    // Download mockup
    $("#saveMockup").on("click", function () {
        let data = canvas.toDataURL("image/png");

        let a = document.createElement("a");
        a.href = data;
        a.download = "mug-mockup.png";
        a.click();
    });

});
