export function warpImageToCylinder(img, size, curvature, flipH, flipV) {

    let off = document.createElement("canvas");
    let ctx = off.getContext("2d");

    off.width = size;
    off.height = size;

    let temp = document.createElement("canvas");
    let tctx = temp.getContext("2d");
    temp.width = size;
    temp.height = size;

    // Draw original
    tctx.drawImage(img, 0, 0, size, size);

    let src = tctx.getImageData(0, 0, size, size);
    let dest = ctx.createImageData(size, size);

    for (let y = 0; y < size; y++) {
        let curveX = Math.sin((y / size) * Math.PI) * curvature;

        for (let x = 0; x < size; x++) {
            let newX = x + curveX;

            if (flipH) newX = size - newX;
            let newY = flipV ? size - y : y;

            newX = Math.min(size - 1, Math.max(0, Math.floor(newX)));

            let srcIndex = (y * size + x) * 4;
            let destIndex = (newY * size + newX) * 4;

            dest.data[destIndex] = src.data[srcIndex];
            dest.data[destIndex + 1] = src.data[srcIndex + 1];
            dest.data[destIndex + 2] = src.data[srcIndex + 2];
            dest.data[destIndex + 3] = src.data[srcIndex + 3];
        }
    }

    ctx.putImageData(dest, 0, 0);

    return off;
}
