<?php
global $product;
if ( ! $product ) {
    return;
}

$product_id = $product->get_id();
$price_html = $product->get_price_html();
$short_desc = $product->get_short_description();
$title      = $product->get_name();
$gallery_ids = $product->get_gallery_image_ids();
$featured_id = $product->get_image_id();
$images = [];

if ($featured_id) {
    $images[] = [
        'file' => wp_get_attachment_image_url($featured_id, 'full'),
        'alt'  => get_post_meta($featured_id, '_wp_attachment_image_alt', true),
    ];
}

foreach ($gallery_ids as $gid) {
    $images[] = [
        'file' => wp_get_attachment_image_url($gid, 'full'),
        'alt'  => get_post_meta($gid, '_wp_attachment_image_alt', true),
    ];
}
$available_variations = $product->get_available_variations();
$regular_price = $product->get_regular_price();
$sale_price    = $product->get_sale_price();
$current_price = $product->get_price();
?>

<main class="overflow-hidden relative">
    <?php require get_template_directory() . '/inc/common-sections/banner-ellipse.php'; ?>
    <?php
    $base_url = get_template_directory_uri() . '/assets/images/';
  
    ?>

    <section class="pt-[145px]! relative">
        <div class="container">
            <?php require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php'; ?>
        </div>
        <div class="container">
            <div class="flex flex-col flex-wrap md:flex-row xl:space-x-30 lg:space-x-15 md:space-x-10 space-y-7.5 md:space-y-0">
                <div class="w-full xl:w-[calc(45%-120px)] lg:w-[calc(45%-60px)] md:w-[calc(45%-40px)] relative flex flex-col space-y-2.5 md:space-y-7.5">
                    <div class="mainSlider w-full leading-0">
                        <?php foreach ($images as $index => $image): ?>
                            <button class="mainSliderItem hidden active aspect-square border-0 outline-0 bg-transparent cursor-zoom-in duration-400 max-w-full w-full" data-modal-target="shopModal" data-modal-toggle="shopModal">
                                <img src="<?= esc_url( $image['file']); ?>"
                                    alt="<?= esc_attr($image['alt']); ?>"
                                    class="w-full h-full object-cover bg-(--bg2)">
                            </button>
                        <?php endforeach; ?>
                    </div>

                    <div class="navSlider flex w-full space-x-2.5 scrollSlider hide-scrollbar whitespace-nowrap overflow-x-auto">
                        <?php foreach ($images as $index => $image): ?>
                            <button
                                class="navBtn rounded-xl overflow-hidden cursor-pointer w-20 min-w-20 h-20 xl:w-26 xl:min-w-26 xl:h-26 border border-(--queen-pink) outline-0 [&.active]:border-(--primary-marigold) <?php echo $index === 0 ? 'active' : ''; ?>">
                                <img
                                    src="<?= esc_url( $image['file']); ?>"
                                    alt="<?= esc_attr($image['alt']); ?>"
                                    class="w-full h-full object-cover bg-(--bg2)">
                            </button>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="w-full md:w-[55%] space-y-5">
                    <div class="space-y-1">
                        <h1 class="font-normal uppercase text-2xl lg:text-[46px] leading-[140%] lg:leading-[129%]">
                            <?php echo esc_html($title); ?>
                        </h1>
                        <div class="font-medium text-sm leading-[180%] text-(--phthalo-green)/60">
                          <?php echo wp_kses_post($short_desc); ?>
                        </div>
                    </div>

                    <div class="shop-certifications">
                        <!-- Include certifications -->
                        <?php
                        require get_template_directory() . '/inc/common-sections/certifications.php';
                        ?>
                    </div>

                    <div class="font-degila text-(--phthalo-green) text-2xl lg:text-[32px] leading-[100%] space-x-4 flex items-center justify-center sm:justify-start product-price">
                    
                       
                            <div class="line-through text-(--phthalo-green)/60">
                                <?php echo  get_woocommerce_currency_symbol();?><span class="regular-price"></span>
                            </div>
                            <div>
                               <?php echo  get_woocommerce_currency_symbol();?> <span class="sale-price"></span>
                            </div>
                       
                           
            
                    </div>

                    <div class="flex flex-col sm:flex-row items-center sm:space-x-4 space-y-4 sm:space-y-0">
                        <h6 class="font-normal text-base text-(--phthalo-green) text-nowrap">
                            Quantity
                        </h6>
                        <div class="max-w-[111px] min-w-[111px] rounded-xl min-h-10.5 sm:p-1.5 sm:border border-(--queen-pink) w-full flex text-center qty-sec">
                            <button class="h-7.5 w-7.5 min-w-7.5 flex items-center justify-center border border-(--queen-pink) focus:border-(--primary-marigold) rounded-lg cursor-pointer text-(--phthalo-green) minus">
                                <!-- Icon -->
                                <?php require get_template_directory() . '/assets/icons/minus.php'; ?>
                            </button>
                            <input class="quantity focus:border-0 focus:outline-0 w-full border-0 rounded-0 p-0.5 min-h-7.5 h-7.5 bg-transparent text-center outline-none shadow-none [-moz-appearance:textfield] [&::-webkit-inner-spin-button]:m-0 [&::-webkit-inner-spin-button]:appearance-none [&::-webkit-outer-spin-button]:m-0 [&::-webkit-outer-spin-button]:appearance-none" type="number" name="quantity" id="" value="1">
                            <button class="h-7.5 w-7.5 min-w-7.5 flex items-center justify-center border border-(--queen-pink) focus:border-(--primary-marigold) rounded-lg cursor-pointer text-(--phthalo-green) plus">
                                <!-- Icon -->
                                <?php require get_template_directory() . '/assets/icons/plus.php'; ?>
                            </button>
                        </div>
                    </div>

                    <div class="space-y-5">
                        <div class="text-center text-[15px] text-(--phthalo-green)/60 space-y-0.5">
                            <img
                                class="object-cover object-center max-h-6 min-w-12 mx-auto"
                                src="<?php echo get_template_directory_uri(); ?>/assets/images/fav-icon2.png" alt="Banner Icon">
                            <span>
                                This product exists in <?php  if(!empty($available_variations)) echo count($available_variations); ?> sizes
                            </span>
                        </div>
                        <div class="space-y-5 sm:space-y-0 sm:space-x-5 flex flex-col sm:flex-row">
                        
                            <?php  foreach ($available_variations as $variation): ?>
                                <?php
                                $vid  = $variation['variation_id'];
                                $size = $variation['attributes']['attribute_pa_size'];
                                $price = $variation['display_price'];
                                $variation_description=$variation['variation_description'];
                                ?>
                                <div class="w-full shrink basis-auto grow">
                                     <input id="variation<?php echo esc_attr($vid); ?>"
                                    type="radio"
                                    name="variation_id"
                                    data-attribute_pa_size="<?php echo $size;?>"
                                    value="<?php echo esc_attr($vid); ?>"
                                    class="hidden peer" />
                                    <label
                                        for="variation<?php echo $vid; ?>"
                                        class="rounded-xl min-h-[81px] h-full p-2 py-4 border border-(--queen-pink) flex flex-col items-center justify-center space-y-1 cursor-pointer text-center peer-checked:border-(--primary-marigold) bg-(--bg2)" data-price="<?php echo esc_attr($price); ?>" data-regular="<?php echo esc_attr($variation['display_regular_price']); ?>" data-sale="<?php echo esc_attr($variation['display_price']); ?>">
                                        <span class="font-semibold text-base text-(--phthalo-green) uppercase">
                                             <?php echo esc_html($size); ?>
                                        </span>
                                        <span class="font-medium text-sm text-(--phthalo-green)/60">
                                              <?php echo $variation_description; ?>
                                        </span>
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="space-y-5 sm:space-y-0 sm:space-x-5 flex flex-col sm:flex-row">
                        <a href="<?php echo site_url('cart'); ?>"
                            class="addToCart btn-s-outline w-full shrink basis-auto grow uppercase! font-semibold! lg:text-base! text-sm! bg-(--bg2)">
                            <span class="relative z-10 flex items-center justify-center space-x-2.5">
                                <!-- Icon -->
                                <span class="cart-icon">
                                    <?php require get_template_directory() . '/assets/icons/cart.php'; ?>
                                </span>
                                <span>add to cart</span>
                            </span>
                        </a>
                        <a href="javascript:void(0);"
                            class="btn-secondary w-full shrink basis-auto grow uppercase! font-semibold! lg:text-base! text-sm! wcProductBuy">
                            <span class="relative z-10">Buy Now</span>
                        </a>
                    </div>
                    <div class="message woocommerce-invalid"></div>
                    <div>
                        <?php

                        $tabs = [
                            [
                                'id' => 'description',
                                'label' => 'Description',
                                'content' => get_the_content(),
                            ],
                            [
                                'id' => 'ingredients',
                                'label' => 'Ingredients',
                                'content' => get_field('ingredients'),
                            ],
                            [
                                'id' => 'how-to-use',
                                'label' => 'How to use',
                                'content' => get_field('how_to_use'),
                            ],
                            [
                                'id' => 'directions',
                                'label' => 'Directions',
                                'content' => get_field('directions'),
                            ],
                            [
                                'id' => 'shipping-returns',
                                'label' => 'shipping & returns',
                                'content' => get_field('shipping_returns'),
                            ],
                        ];
                        ?>


                        <div class="mb-5 border-b border-b-(--queen-pink) border-default">
                            <ul
                                class="flex -mb-px text-sm font-semibold leading-[100%] text-center scrollSlider hide-scrollbar whitespace-nowrap overflow-x-auto justify-start"
                                role="tablist"
                                data-tabs-toggle="#luxuriousTabContent"
                                data-tabs-active-classes="text-(--phthalo-green) border-(--phthalo-green)"
                                data-tabs-inactive-classes="text-(--phthalo-green)/60 border-transparent">
                                <?php foreach ($tabs as $index => $tab): ?>
                                    <li role="presentation">
                                        <button
                                            class="inline-block px-3 py-2.5 border-b-4 text-(--phthalo-green)/60 hover:text-(--phthalo-green) hover:border-(--phthalo-green) uppercase duration-400 cursor-pointer text-nowrap"
                                            data-tabs-target="#tab-<?= esc_attr($tab['id']); ?>"
                                            type="button"
                                            role="tab"
                                            aria-selected="<?= $index === 0 ? 'true' : 'false'; ?>">
                                            <?= esc_html($tab['label']); ?>
                                        </button>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <div id="luxuriousTabContent">
                            <?php foreach ($tabs as $index => $tab): ?>
                                <div
                                    id="tab-<?= esc_attr($tab['id']); ?>"
                                    class="<?= $index === 0 ? '' : 'hidden'; ?>"
                                    role="tabpanel">
                                    <div class="font-medium text-sm leading-[165%] text-(--phthalo-green)/60">
                                        <?php if($tab['content']): ?>
                                        <?=   wp_kses_post( apply_filters('the_content', $tab['content'])); ?>
   
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div id="shopModal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-full max-h-screen duration-400 bg-(--bg2)">
        <div class="relative w-full max-w-full max-h-full h-full flex justify-center items-center">
            <!-- Modal body -->
            <div class="max-h-screen">
                <div class="modalSlider flex transition-transform ease-in-out w-full max-h-screen">

                    <?php foreach ($images as $index => $image): ?>
                        <div class="modalSliderItem min-w-full max-h-screen flex items-center justify-center">
                            <img src="<?= esc_url( $image['file']); ?>"
                                alt="<?= esc_attr($image['alt']); ?>"
                                class="w-auto m-auto h-auto max-h-screen object-cover bg-(--bg2)">
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>
            <!-- Modal footer -->
            <div class="absolute flex items-center justify-center w-max mx-auto bottom-0 left-1/2 -translate-x-1/2 md:space-x-4.5 space-x-3 pb-10">
                <button class="previewBtn cursor-pointer text-white bg-(--theme-color) p-0 rounded-full w-11 h-11 flex justify-center items-center">
                    <!-- Icon -->
                    <?php require get_template_directory() . '/assets/icons/preview.php'; ?>
                </button>

                <button type="button" class="text-white bg-(--theme-color) p-0 cursor-pointer rounded-full w-12.5 h-12.5 md:w-14 md:h-14 flex justify-center items-center" data-modal-hide="shopModal">
                    <!-- Icon -->
                    <?php require get_template_directory() . '/assets/icons/xmark.php'; ?>
                </button>

                <button class="nextBtn cursor-pointer text-white bg-(--theme-color) p-0 rounded-full w-11 h-11 flex justify-center items-center">
                    <!-- Icon -->
                    <?php require get_template_directory() . '/assets/icons/next.php'; ?>
                </button>
            </div>
        </div>
    </div>

<?php  $reviewdata=reviews_data(); ?>
    <section class="section-padding">
        <div class="container">
            <div class="lg:space-y-12.5 space-y-7.5">
                <div class="text-(--phthalo-green) text-center sm:text-start">
                    <h2 class="font-semibold text-2xl font-montserrat leading-[39px] tracking-[0.32px]">
                        Rating & Reviews
                    </h2>
                </div>
                <div class="flex md:flex-row flex-col flex-wrap md:space-x-7.5 xl:space-x-12.5 space-y-7.5 md:space-y-0">
                    <div class="md:w-[calc(55.5%-30px)] xl:w-[calc(55.5%-50px)] w-full sm:space-x-5 space-y-5 sm:space-y-0 flex flex-col sm:flex-row">
                        <div class="space-y-3 md:space-y-5 text-center sm:text-start">
                            <div class="text-6xl lg:text-8xl xl:text-[154px] font-semibold text-(--phthalo-green) flex items-end text-nowrap sm:justify-start justify-center">
                               <?php echo $reviewdata['average'];?> <span class="text-lg xl:text-[32px] text-(--phthalo-green)/60">/ 5</span>
                            </div>
                            <p class="text-(--phthalo-green)/60 font-degila text-sm md:text-base">
                                (<?php echo $reviewdata['total_review'];?> New Reviews)
                            </p>
                        </div>
                        <div class="space-y-3 md:space-y-5 w-full">
                            <?php
                           
                            $ratings = [
                                [
                                    'stars'   => 5,
                                    'percent' => $reviewdata['5_star_percent'],
                                ],
                                [
                                    'stars'   => 4,
                                    'percent' => $reviewdata['4_star_percent'],
                                ],
                                [
                                    'stars'   => 3,
                                    'percent' => $reviewdata['3_star_percent'],
                                ],
                                [
                                    'stars'   => 2,
                                    'percent' => $reviewdata['2_star_percent'],
                                ],
                                [
                                    'stars'   => 1,
                                    'percent' => $reviewdata['1_star_percent'],
                                ],
                            ];
                            ?>
                            <?php foreach ($ratings as $rating): ?>
                                <div class="w-full flex items-center space-x-2.5 text-lg font-medium">
                                    <div class="text-(--primary-marigold) [&_svg]:w-6 [&_svg]:h-6">
                                        <?php require get_template_directory() . '/assets/icons/rating-star.php'; ?>
                                    </div>
                                    <span><?= esc_html($rating['stars']); ?></span>
                                    <div class="w-full h-2 rounded-full bg-(--phthalo-green)/10 overflow-hidden">
                                        <div
                                            class="h-full bg-(--phthalo-green) rounded-full transition-all duration-400 ease-in-out"
                                            style="width:<?= esc_attr($rating['percent']); ?>%;"
                                            aria-label="<?= esc_attr($rating['stars']); ?> star rating"></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>


                        </div>
                    </div>
                    <div class="reviewSliderWrapper md:w-[44.5%] w-full relative bg-(--primary-marigold)/15 rounded-xl overflow-hidden px-5 py-4 text-(--phthalo-green) leading-[165%]">
                        <div class="w-full max-w-full overflow-hidden">
                            <div class="reviewSlider flex transition-transform duration-600 ease-in-out">
                                <?php
                                $reviews = get_custom_reviews_prepared(200);
                                ?>
                                <?php foreach ($reviews as $review): ?>
                                    <div class="sliderItem space-y-4 w-full min-w-full flex-col flex justify-between">
                                        <div class="space-y-4 w-full">
                                            <div class="space-y-2.5">
                                                <p class="text-lg font-semibold">
                                                    <?= esc_html($review['name']); ?>
                                                </p>

                                                <div class="flex items-center justify-between space-x-2.5">
                                                    <div class="flex space-x-2.5 text-(--primary-marigold)">
                                                        <?php for ($i = 0; $i < $review['rating']; $i++): ?>
                                                            <?php require get_template_directory() . '/assets/icons/rating-star.php'; ?>
                                                        <?php endfor; ?>
                                                    </div>

                                                    <div class="text-(--phthalo-green)/60 font-semibold text-sm">
                                                        <?= esc_html($review['date']); ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="text-(--phthalo-green)/60 font-semibold text-sm line-clamp-3">
                                                <?= esc_html($review['text']); ?>
                                            </div>
                                        </div>

                                        <div class="rounded-full overflow-hidden bg-(--bg2) h-16 w-16 min-w-16">
                                            <img
                                                class="h-full w-full object-cover object-center text-xs flex items-center text-center justify-center"
                                                src="<?= esc_url($review['image']); ?>"
                                                alt="<?= esc_attr($review['name']); ?>">
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <div class="absolute bottom-4 left-1/2 -translate-x-1/2 max-w-25 lg:max-w-37.5 w-full h-1.5 rounded-full bg-(--phthalo-green)/10 overflow-hidden">
                            <div class="progressBar bg-(--phthalo-green) rounded-full overflow-hidden h-full duration-400 ease-in-out">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<style>
    .added_to_cart.wc-forward{
        display:none;
    }
</style>