<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Luxurious_Skincare_Encoder_IT
 */

get_header();

?>

<?php
$post_id    = get_the_ID();
$post_title = get_the_title($post_id);
$post_url   = get_permalink($post_id);
$post_date  = get_the_date('d F Y', $post_id);
$post_cat   = get_the_category($post_id);
$cat_name   = !empty($post_cat) ? esc_html($post_cat[0]->name) : '';
$cat_id     = !empty($post_cat) ? (int) $post_cat[0]->term_id : 0;
$thumb_url  = get_the_post_thumbnail_url($post_id, 'full');
?>

<main class="overflow-hidden relative">
    <?php require get_template_directory() . '/inc/common-sections/banner-ellipse.php'; ?>

    <section class="section-padding md:pt-[145px]! pt-[130px]! relative">
        <div class="container">
            <?php require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php'; ?>
        </div>

        <div class="container">
            <div class="flex flex-col flex-wrap md:flex-row md:space-x-7.5 xl:space-x-12.5 space-y-7.5 md:space-y-0">

                <!-- CONTENT -->
                <div class="md:w-[calc(100%-324px)] xl:w-[calc(100%-344px)] w-full space-y-5">
                    <div class="space-y-2.5">
                        <h1 class="font-light text-(--phthalo-green) text-2xl lg:text-[40px] leading-[120%] line-clamp-3 font-montserrat">
                            <?php echo esc_html($post_title); ?>
                        </h1>

                        <h6 class="flex items-center text-(--phthalo-green)/60 text-sm space-x-1.5">
                            <?php if ($cat_name) : ?>
                                <span><?php echo $cat_name; ?></span>
                                <?php require get_template_directory() . '/assets/icons/dot-icon.php'; ?>
                            <?php endif; ?>
                            <span><?php echo esc_html($post_date); ?></span>
                        </h6>
                    </div>

                    <div class="space-y-5">
                        <?php if ($thumb_url) : ?>
                            <div class="aspect-video rounded-xl overflow-hidden border border-(--queen-pink) w-full">
                                <img
                                    class="object-cover object-center w-full h-full duration-400 group-hover:scale-110"
                                    src="<?php echo esc_url($thumb_url); ?>"
                                    alt="<?php echo esc_attr($post_title); ?>">
                            </div>
                        <?php endif; ?>

                        <div
                            class="lg:space-y-5 space-y-4 font-medium text-sm text-justify text-(--phthalo-green)/60 leading-[165%]
                            [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400
                            [&_h1]:mt-8 [&_h1:first-child]:mt-0
                            [&_h2]:mt-8 [&_h2:first-child]:mt-0
                            [&_h2]:text-lg md:[&_h2]:text-2xl [&_h2]:text-(--phthalo-green)
                            [&_h3]:text-lg md:[&_h3]:text-2xl [&_h3]:text-(--phthalo-green)
                            [&_h4]:text-lg md:[&_h4]:text-2xl [&_h4]:text-(--phthalo-green)
                            [&_ul]:space-y-2.5 [&_ul]:pl-8 [&_li]:list-disc
                            [&_ol]:space-y-2.5 [&_ol]:pl-8">
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>

                <!-- SIDEBAR -->
                <div class="md:w-[294px] w-full lg:space-y-12.5 space-y-7.5">

                    <!-- SOCIAL SHARE -->
                    <div class="space-y-5">
                        <h3 class="text-lg font-semibold leading-[100%] font-montserrat">
                            Social Network
                        </h3>

                        <div class="-m-1">
                            <div class="flex flex-wrap">
                                <?php
                                $socials = [
                                    [
                                        'name'  => 'Instagram',
                                        'icon'  => 'social-instagram.php',
                                        'bg'    => 'linear-gradient(45deg,#F58529,#DD2A7B,#8134AF,#515BD4)',
                                        'url'   => 'https://www.instagram.com/?url='
                                    ],
                                    [
                                        'name'  => 'Twitter',
                                        'icon'  => 'social-twitter.php',
                                        'bg'    => '#1DA1F2',
                                        'url'   => 'https://twitter.com/intent/tweet?url='
                                    ],
                                    [
                                        'name'  => 'Facebook',
                                        'icon'  => 'social-facebook.php',
                                        'bg'    => '#1877F2',
                                        'url'   => 'https://www.facebook.com/sharer/sharer.php?u='
                                    ],
                                    [
                                        'name'  => 'YouTube',
                                        'icon'  => 'social-youtube.php',
                                        'bg'    => '#FF0000',
                                        'url'   => 'https://www.youtube.com/'
                                    ],
                                    [
                                        'name'  => 'Pinterest',
                                        'icon'  => 'social-pinterest.php',
                                        'bg'    => '#E60023',
                                        'url'   => 'https://pinterest.com/pin/create/button/?url='
                                    ],
                                    [
                                        'name'  => 'LinkedIn',
                                        'icon'  => 'social-linkedin.php',
                                        'bg'    => '#0A66C2',
                                        'url'   => 'https://www.linkedin.com/shareArticle?url='
                                    ],
                                ];

                                foreach ($socials as $social) :
                                    $share_url = esc_url($social['url'] . rawurlencode($post_url));
                                ?>
                                    <a href="<?php echo $share_url; ?>" target="_blank" rel="noopener noreferrer"
                                        class="w-[calc(50%-8px)] flex items-center justify-start rounded-lg p-1.5 overflow-hidden space-x-2 m-1 bg-(--light-khaki) min-h-11 duration-400 hover:bg-(--phthalo-green) hover:text-white text-sm">
                                        <div
                                            class="rounded-sm h-8 w-8 min-w-8 flex items-center justify-center [&_svg]:h-5 [&_svg]:w-5 [&_svg]:fill-white"
                                            style="background: <?php echo esc_attr($social['bg']); ?>;">
                                            <?php include get_template_directory() . '/assets/icons/' . esc_attr($social['icon']); ?>
                                        </div>
                                        <span><?php echo esc_html($social['name']); ?></span>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <!-- BLOG TABS -->
                    <div class="space-y-5">
                        <?php
                        $tabs = [
                            ['id' => 'popular', 'label' => 'Popular', 'limit' => 4],
                            ['id' => 'recent', 'label' => 'Recent', 'limit' => 2],
                            ['id' => 'trendy', 'label' => 'Trendy', 'limit' => 3],
                        ];
                        ?>

                        <div class="flex text-sm font-semibold leading-[100%] text-center rounded-xl overflow-hidden bg-(--queen-pink)"
                            id="default-tab"
                            data-tabs-toggle="#blogTab"
                            data-tabs-active-classes="text-(--phthalo-green)"
                            data-tabs-inactive-classes="text-(--phthalo-green)/60"
                            role="tablist">
                            <?php foreach ($tabs as $i => $tab) : ?>
                                <button
                                    class="inline-block min-h-11.5 w-full px-1 py-2.5 <?php echo $i !== array_key_last($tabs) ? 'border-r border-(--bg2)' : ''; ?>
                                    text-(--phthalo-green)/60 hover:text-(--phthalo-green) uppercase duration-400 cursor-pointer"
                                    id="tab-<?php echo esc_attr($tab['id']); ?>"
                                    data-tabs-target="#<?php echo esc_attr($tab['id']); ?>"
                                    type="button" role="tab">
                                    <?php echo esc_html($tab['label']); ?>
                                </button>
                            <?php endforeach; ?>
                        </div>

                        <div id="blogTab">
                            <?php foreach ($tabs as $tab) : ?>
                                <div class="hidden space-y-3" id="<?php echo esc_attr($tab['id']); ?>" role="tabpanel">
                                    <?php
                                    set_query_var('grid_limit', (int) $tab['limit']);
                                    set_query_var('grid_category', $tab['id'] === 'trendy' ? $cat_id : 0);
                                    set_query_var('grid_type', $tab['id']);
                                    get_template_part('template-parts/blog-tabs/tab-grid');
                                    ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
</main>


<?php
get_footer();
