<?php
$privacy_page_id = get_field('privacy_policy_page', THEME_SETTINGS_ID);
$privacy_url     = $privacy_page_id ? get_permalink($privacy_page_id) : '#';
$term_page_id = get_field('term_page', THEME_SETTINGS_ID);
$term_url     = $term_page_id ? get_permalink($term_page_id) : '#';
?>
<div id="sideCartDrawer" class="sideDrawer fixed top-0 right-0 z-40 bottom-0 transition-transform translate-x-full bg-white w-full max-w-[375px] lg:max-w-[450px] duration-400 flex flex-col" tabindex="-1" aria-labelledby="drawer-right-label">
    <div class="drawer-header px-4 py-5 md:px-8 md:py-4.5 border-b border-[#EBEBEB] flex justify-between items-center">
        <h5 class="uppercase text-base md:text-lg text-(--phthalo-green) font-normal leading-[140%]">
            Side Bar
        </h5>
        <button class="hover:opacity-65 duration-400 bg-transparent p-0 border-0 h-6 w-6 flex items-center justify-center cursor-pointer relative text-(--phthalo-green)" type="button" data-drawer-hide="sideCartDrawer" aria-controls="sideCartDrawer">
            <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
            </svg>
            <span class="sr-only">Close menu</span>
        </button>
    </div>
    <div class="drawer-body overflow-y-auto grow text-(--phthalo-green)">
        <div class="flex flex-col w-full">

            <!-- Dynamic Menu -->
            <?php
            $menu_items = get_primary_menu_items();
            foreach ($menu_items as $item):
                $is_active = false;

                // Home
                if (is_front_page() && $item->url === home_url('/')) {
                    $is_active = true;
                }

                // Normal pages
                elseif (is_page() && get_permalink() === $item->url) {
                    $is_active = true;
                }

                // Woo Shop page
                elseif (function_exists('is_shop') && is_shop() && $item->url === wc_get_page_permalink('shop')) {
                    $is_active = true;
                }

                // Single product (optional: keep Shop active)
                elseif (function_exists('is_product') && is_product() && $item->url === wc_get_page_permalink('shop')) {
                    $is_active = true;
                }
            ?>
                <a
                    class="<?php echo $is_active ? 'active' : ''; ?> p-4 md:px-8 border-b border-[#EBEBEB] text-(--phthalo-green) hover:text-(--primary-marigold) duration-400 font-medium text-base leading-[140%] capitalize [&.active]:text-(--primary-marigold)"
                    href="<?php echo esc_url($item->url); ?>">
                    <span>
                        <?php echo esc_html($item->title); ?>
                    </span>
                </a>
            <?php endforeach; ?>

            <a
                href="<?php echo site_url('cart'); ?>"
                class="p-4 md:px-8 border-b border-[#EBEBEB] text-(--phthalo-green) hover:text-(--primary-marigold) duration-400 font-medium text-base leading-[140%] capitalize flex items-center space-x-2">
                <!-- Icon -->
                <?php require get_template_directory() . '/assets/icons/cart-icon.php'; ?>
                <span>My Cart</span>
            </a>

            <?php $account_url = wc_get_page_permalink('myaccount'); ?>
            <a
                href="<?php echo esc_url($account_url); ?>"
                class="p-4 md:px-8 border-b border-[#EBEBEB] text-(--phthalo-green) hover:text-(--primary-marigold) duration-400 font-medium text-base leading-[140%] capitalize flex items-center space-x-2"
                aria-label="My Account">
                <!-- Icon -->
                <?php require get_template_directory() . '/assets/icons/my-account-icon.php'; ?>
                <span>My Account</span>
            </a>

            <!-- Privacy Policy Link -->
            <a
                href="<?php echo $privacy_url; ?>"
                class="p-4 md:px-8 border-b border-[#EBEBEB] text-(--phthalo-green) hover:text-(--primary-marigold) duration-400 font-medium text-base leading-[140%] capitalize">
                Privacy policy
            </a>

            <!-- Terms of Service Link -->
            <a
                href="<?php echo $term_url; ?>"
                class="p-4 md:px-8 border-b border-[#EBEBEB] text-(--phthalo-green) hover:text-(--primary-marigold) duration-400 font-medium text-base leading-[140%] capitalize">
                Terms of service
            </a>
        </div>
    </div>
    <div class="drawer-footer border-t border-[#EBEBEB]">
        <a
            href="<?php echo site_url('shop'); ?>"
            class="p-4 md:px-8 border-b border-[#EBEBEB] text-(--phthalo-green) hover:text-(--primary-marigold) duration-400 font-medium text-sm leading-[140%] capitalize inline-block w-full">
            Visit our shop page.
        </a>
    </div>
</div>