<?php
/*

Template Name: Page Home

Description: A custom home page template

*/
get_header();
?>
<main class="overflow-hidden">
    <?php
    $banner = get_field('banner_section');
    ?>
    <section class="section-padding md:pt-[145px]! sm:pt-[130px]! pt-[82px]! relative">

        <div class="container xl:px-20! lg:px-8! sm:px-5! px-0!">

            <div class="flex flex-col sm:flex-row sm:items-center sm:space-x-7.5 xl:space-x-12.5 relative">

                <div class="w-full sm:w-1/2 p-5 sm:p-0 absolute inset-0 sm:static z-10 flex items-center justify-center sm:block bg-black/20 sm:bg-transparent">

                    <div class="w-full sm:max-w-[500px] text-center sm:text-right space-y-[45px] md:space-y-15">

                        <div class="sm:space-y-2.5">

                            <?php if ($banner['banner_title']) { ?>

                                <h1 class="font-normal uppercase text-4xl sm:text-3xl lg:text-[46px] leading-[160%] sm:leading-[140%] lg:leading-[129%] italic sm:not-italic text-white sm:text-(--phthalo-green)">

                                    <?php echo $banner['banner_title']; ?>

                                </h1>

                            <?php } ?>
                            <?php if ($banner['banner_short_description']) { ?>

                                <div class="font-medium text-[15px] leading-[180%] max-w-[470px] sm:ms-auto hidden sm:block w-full">

                                    <?php echo $banner['banner_short_description']; ?>

                                </div>

                            <?php } ?>

                        </div>
                        <div class="flex justify-end items-center sm:items-end md:items-center flex-col-reverse md:flex-row md:space-x-4.5 space-y-2.5 md:space-y-0 space-y-reverse md:space-x-reverse">

                            <?php

                            require get_template_directory() . '/inc/common-sections/shop-buttons.php';

                            ?>

                        </div>

                    </div>

                </div>

                <div class="w-full sm:w-1/2 text-center leading-0">

                    <?php if ($banner['video_url']) { ?>

                        <button class="videoPlayBtnWithFullScreen w-full cursor-pointer sm:max-w-[340px] mx-auto">

                            <div class="videoContainer relative w-full 

                            sm:aspect-6/9 sm:rounded-xl overflow-hidden 

                            [&>img]:w-full sm:[&>img]:h-full [&>img]:h-[638px] [&>img]:object-cover [&>img]:object-center 

                            [&>iframe]:w-full sm:[&>iframe]:h-full [&>iframe]:h-[638px] [&>iframe]:object-cover [&>iframe]:object-center 

                            [&>video]:w-full sm:[&>video]:h-full [&>video]:h-[638px] [&>video]:object-cover [&>video]:object-center

                        ">

                                <video width="100%" muted playsinline autoplay loop preload="auto"

                                    id="<?php echo $id; ?>_thumb">

                                    <source

                                        src="<?php echo $banner['video_url']; ?>"

                                        type="video/mp4">

                                </video>

                                <span

                                    class="

                                    hidden

                                    absolute

                                    top-1/2 left-1/2

                                    -translate-x-1/2 -translate-y-1/2

                                    w-[60px] h-[60px]

                                    bg-[rgba(0,0,0,0.7)]

                                    rounded-full

                                    shadow-[0_4px_15px_rgba(0,0,0,0.4)]

                                    sm:flex items-center justify-center

                                    p-0

                                    text-[0]

                                    transition-all duration-300 ease-in-out

                                    hover:bg-[rgba(0,0,0,0.9)]

                                    hover:scale-[1.15]
 ">

                                    <svg

                                        width="40"

                                        height="40"

                                        viewBox="0 0 24 24"

                                        fill="white">

                                        <path d="M8 5v14l11-7z" />

                                    </svg>

                                </span>

                            </div>

                        </button>

                    <?php  } ?>

                </div>

            </div>

        </div>

        <div class="hidden md:block bg-[linear-gradient(to_right,_#E9EBF0,_rgba(223,_218,_199,_0.3))] aspect-square w-full max-w-[80%] absolute top-[-15%] right-[-20%] 2xl:top-[-25%] 2xl:right-[-30%] rounded-full pointer-events-none -z-10 -rotate-90 animate-gradientMovement"></div>

    </section>





    <?php

    $banner_cards = get_field('home_cards_section') ?: [];



    $show_section =

        !empty($banner_cards['card_1_icon']) || !empty($banner_cards['card_1_title']) ||

        !empty($banner_cards['card_2_icon']) || !empty($banner_cards['card_2_title']) ||

        !empty($banner_cards['card_3_icon']) || !empty($banner_cards['card_3_title']);

    ?>



    <?php if ($show_section): ?>

        <section>

            <div class="container">

                <div class="-m-2.5 md:-m-3">

                    <div class="flex justify-center flex-wrap">



                        <?php

                        $cards = [

                            [

                                'icon'  => $banner_cards['card_1_icon'] ?? null,

                                'title' => $banner_cards['card_1_title'] ?? '',

                            ],

                            [

                                'icon'  => $banner_cards['card_2_icon'] ?? null,

                                'title' => $banner_cards['card_2_title'] ?? '',

                            ],

                            [

                                'icon'  => $banner_cards['card_3_icon'] ?? null,

                                'title' => $banner_cards['card_3_title'] ?? '',

                            ],

                        ];

                        ?>



                        <?php foreach ($cards as $card): ?>

                            <?php if ($card['icon'] || $card['title']): ?>



                                <div class="w-[calc(100%-20px)] sm:w-[calc(50%-24px)] lg:w-[calc(33.33333%-24px)] m-2.5 md:m-3 max-w-[400px] md:max-w-full rounded-xl min-h-[125px] lg:p-9 p-5 flex items-center md:space-x-6 space-y-5 md:space-y-0 md:flex-row flex-col shadow-[0_0px_4px_0_rgba(227,161,41,0.3)] bg-[linear-gradient(180deg,rgba(233,235,240,0.02)_0%,rgba(227,161,41,0.04)_100%)] duration-400 border border-transparent hover:border-(--primary-marigold) hover:shadow-[0_4px_12px_0_rgba(227,161,41,0.4)] relative card-box-animation bg-(--bg2)">



                                    <?php if ($card['icon']): ?>

                                        <div class="max-w-[65px] w-full text-center shrink-0">

                                            <?php echo wp_get_attachment_image(

                                                $card['icon']['ID'],

                                                'full',

                                                false,

                                                ['class' => 'object-contain object-center max-h-14 mx-auto']

                                            ); ?>

                                        </div>

                                    <?php endif; ?>



                                    <?php if ($card['title']): ?>

                                        <h3 class="font-normal text-(--phthalo-green) text-lg leading-[135%] tracking-[0.32px] text-center md:text-start">

                                            <?php echo esc_html($card['title']); ?>

                                        </h3>

                                    <?php endif; ?>



                                </div>



                            <?php endif; ?>

                        <?php endforeach; ?>



                    </div>

                </div>

            </div>

        </section>

    <?php endif; ?>







    <?php



    $benefits = get_field('product_benefits_section') ?: [];

    $leftInfo = get_theme_option_repeater_values('product_benefits_left_side_info', get_the_ID());

    $rightInfo = get_theme_option_repeater_values('product_benefits_right_side_info', get_the_ID());



    $title_column = $benefits['title_column'] ?? [];

    $sub_title    = $title_column['section_sub_title'] ?? '';

    $title        = $title_column['section_title'] ?? '';



    $image = $benefits['image'] ?? null;



    $has_content =

        $sub_title ||

        $title ||

        $image ||

        $leftInfo ||

        $rightInfo;

    ?>



    <?php if ($has_content): ?>

        <section class="section-padding overflow-hidden relative">

            <div class="container">

                <div class="lg:space-y-12.5 space-y-7.5">



                    <!-- Title -->

                    <?php if ($sub_title || $title): ?>

                        <div class="text-center space-y-4 text-(--phthalo-green)">

                            <?php if ($sub_title): ?>

                                <p class="text-[13px] leading-[21px] tracking-[0.32px] font-semibold text-(--phthalo-green)/60">

                                    <?php echo esc_html($sub_title); ?>

                                </p>

                            <?php endif; ?>



                            <?php if ($title): ?>

                                <h2 class="font-normal text-[29px] leading-[39px] tracking-[0.32px]">

                                    <?php echo esc_html($title); ?>

                                </h2>

                            <?php endif; ?>

                        </div>

                    <?php endif; ?>



                    <div class="flex flex-col md:flex-row md:items-center md:justify-center xl:space-x-12.5 md:space-x-7.5 space-y-5 md:space-y-0">



                        <!-- LEFT SIDE -->

                        <?php

                        if (!empty($leftInfo)) {

                        ?>

                            <div class="grow shrink basis-auto w-full md:text-right space-y-6 lg:space-y-15">

                                <?php

                                foreach ($leftInfo as $item) :

                                ?>

                                    <div class="group flex items-center md:justify-end md:justify_e space-x-5 md:space-x-reverse md:flex-row-reverse">



                                        <div class="lg:h-14 lg:w-14 lg:min-w-14 h-12.5 w-12.5 min-w-12.5 flex items-center justify-center rounded-full border border-[#E3D0D2] group-hover:border-(--primary-marigold) duration-400 relative overflow-hidden circle-animation">



                                            <?php echo wp_get_attachment_image($item['icon'], 'full', false, [

                                                'class' => 'w-7.5 h-7.5 object-contain object-center',

                                                'alt' => 'Benefits Icon'

                                            ]);

                                            ?>



                                        </div>



                                        <?php if (!empty($item['short_title'])): ?>

                                            <p class="font-medium text-(--phthalo-green) text-base leading-[165%] tracking-[0.32px] md:max-w-[250px]">

                                                <?php echo esc_html($item['short_title']); ?>

                                            </p>

                                        <?php endif; ?>



                                    </div>

                                <?php endforeach; ?>

                            </div>

                        <?php } ?>





                        <!-- CENTER IMAGE -->

                        <?php if ($image): ?>

                            <div class="grow shrink basis-auto w-full lg:max-w-[345px] md:max-w-[200px]">

                                <div class="mx-auto max-w-[345px] lg:max-w-[345px] md:max-w-[200px]">

                                    <?php echo wp_get_attachment_image(

                                        $image['ID'],

                                        'full',

                                        false,

                                        ['class' => 'mx-auto object-contain object-center']

                                    ); ?>

                                </div>

                            </div>

                        <?php endif; ?>



                        <!-- RIGHT SIDE -->

                        <?php

                        if (!empty($rightInfo)) {

                        ?>

                            <div class="grow shrink basis-auto w-full text-right md:text-left space-y-6 lg:space-y-15">

                                <?php

                                foreach ($rightInfo as $item) :

                                ?>

                                    <div class="group flex items-center justify-end md:justify-start md:justify_s space-x-5 md:space-x-reverse md:flex-row-reverse">



                                        <?php if ($item['short_title']): ?>

                                            <p class="font-medium text-(--phthalo-green) text-base leading-[165%] tracking-[0.32px] md:max-w-[250px]">

                                                <?php echo esc_html($item['short_title']); ?>

                                            </p>

                                        <?php endif; ?>



                                        <div class="lg:h-14 lg:w-14 lg:min-w-14 h-12.5 w-12.5 min-w-12.5 flex items-center justify-center rounded-full border border-[#E3D0D2] group-hover:border-(--primary-marigold) duration-400 relative overflow-hidden circle-animation">

                                            <?php echo wp_get_attachment_image($item['icon'], 'full', false, [

                                                'class' => 'w-7.5 h-7.5 object-contain object-center',

                                                'alt' => 'Benefits Icon'

                                            ]);

                                            ?>

                                        </div>



                                    </div>

                                <?php endforeach; ?>

                            </div>

                        <?php } ?>



                    </div>

                </div>

            </div>



            <!-- Background Shape -->

            <div class="hidden md:block bg-[linear-gradient(to_right,_#E9EBF0,_rgba(223,_218,_199,_0.3))] aspect-square w-full max-w-[80%] absolute top-[205px] left-[-17%] rounded-full pointer-events-none -z-10 rotate-25 animate-gradientMovement"></div>

        </section>

    <?php endif; ?>



    <?php

    $video = get_field('video_url', THEME_SETTINGS_ID) ?: [];
    $videourl = acf_oembed_get_url($video);

    ?>

    <?php if ($video):
        $thumbs = get_youtube_poster($videourl);
    ?>

        <section>

            <div class="container sm:px-0! max-w-full!">

                <div class="relative aspect-video video-player sm:aspect-auto sm:h-[350px] md:h-[400px] lg:h-[500px] w-full rounded-xl sm:rounded-none overflow-hidden [&_iframe]:h-full [&_iframe]:w-full [&_iframe]:object-cover" data-video="<?php echo esc_url($videourl); ?>">
                    <img
                        src="<?php echo esc_url($thumbs['max']); ?>"
                        alt="video"
                        class="w-full h-full object-cover object-center"
                        loading="lazy">

                    <!-- Play button -->
                    <span class="cursor-pointer absolute video-play top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[60px] h-[60px] bg-[rgba(0,0,0,0.7)] rounded-full shadow-[0_4px_15px_rgba(0,0,0,0.4)] flex items-center justify-center p-0 text-[0]transition-all duration-300 ease-in-out hover:bg-[rgba(0,0,0,0.9)] hover:scale-[1.15]">
                        <svg
                            width="40"
                            height="40"
                            viewBox="0 0 24 24"
                            fill="white">
                            <path d="M8 5v14l11-7z" />
                        </svg>
                    </span>
                </div>
            </div>
        </section>

    <?php endif; ?>

    <?php

    $reviews = get_field('reviews_section') ?: [];
    $title_column = $reviews['title_column'] ?? [];

    $sub_title    = $title_column['section_sub_title'] ?? '';

    $title        = $title_column['section_title'] ?? '';



    $has_content =

        $sub_title ||

        $title;

    ?>

    <?php if ($has_content): ?>

        <section class="section-padding pb-0!">

            <div class="container">

                <div class="lg:space-y-12.5 space-y-7.5">

                    <?php if ($sub_title || $title): ?>

                        <div class="text-center space-y-4 text-(--phthalo-green)">

                            <?php if ($sub_title): ?>

                                <p class="text-[13px] leading-[21px] tracking-[0.32px] font-semibold text-(--phthalo-green)/60">

                                    <?php echo esc_html($sub_title); ?>

                                </p>

                            <?php endif; ?>



                            <?php if ($title): ?>

                                <h2 class="font-normal text-[29px] leading-[39px] tracking-[0.32px]">

                                    <?php echo esc_html($title); ?>

                                </h2>

                            <?php endif; ?>

                        </div>

                    <?php endif; ?>

                    <div class="reviewHomeSliderWrapper flex flex-col lg:space-y-12.5 space-y-7.5">

                        <div>

                            <div class="-m-2.5 md:-m-3">

                                <div class="reviewSlider flex justify-start overflow-x-auto scrollSlider hide-scrollbar">

                                    <?php

                                    $reviews = get_custom_reviews_prepared(12);
                                    // Example reviews array (replace with actual data source)


                                    ?>

                                    <?php foreach ($reviews as $review): ?>

                                        <div class="cartItem 

                                w-[calc(100%-20px)] sm:w-[calc(50%-24px)] lg:w-[calc(33.33333%-24px)] 

                                min-w-[calc(100%-20px)] sm:min-w-[calc(50%-24px)] lg:min-w-[calc(33.33333%-24px)]

                                m-2.5 md:m-3 max-w-[400px] md:max-w-full rounded-xl min-h-[125px] p-5 shadow-[0_0px_4px_0_rgba(227,161,41,0.3)] bg-[linear-gradient(180deg,rgba(233,235,240,0.02)_0%,rgba(227,161,41,0.04)_100%)] 

                                duration-400 border border-transparent hover:border-(--primary-marigold) hover:shadow-[0_4px_12px_0_rgba(227,161,41,0.4)] 

                                relative bg-[#F9F9F9]

                                space-y-10 flex flex-col justify-between

                                ">

                                            <div class="font-medium text-[13px] leading-[165%] text-(--phthalo-green)/60">

                                                <?php echo esc_html($review['review']); ?>

                                            </div>

                                            <div class="flex items-center space-x-2.5">

                                                <div class="text-(--queen-pink) [&_svg]:w-15 [&_svg]:h-15">

                                                    <!-- Icon -->

                                                    <?php require get_template_directory() . '/assets/icons/user-icon.php'; ?>

                                                </div>

                                                <div class="space-y-2">

                                                    <div class="font-semibold text-(--phthalo-green) text-base leading-none">

                                                        <?php echo esc_html($review['name']); ?>

                                                    </div>

                                                    <div class="text-xs leading-[165%] text-(--phthalo-green)/60 font-medium flex items-center space-x-1.5">

                                                        <!-- Icon -->

                                                        <?php require get_template_directory() . '/assets/icons/circle-check.php'; ?>

                                                        <span>

                                                            <?php echo esc_html($review['role']); ?>

                                                        </span>

                                                    </div>

                                                    <div class="flex items-center space-x-1.5">

                                                        <?php for ($i = 0; $i < $review['rating']; $i++): ?>

                                                            <img

                                                                class="w-3.5 h-3.5 object-contain object-center"

                                                                src="<?php echo get_template_directory_uri(); ?>/assets/images/star.svg; ?>" alt="Star">

                                                        <?php endfor; ?>

                                                    </div>

                                                </div>

                                            </div>

                                        </div>

                                    <?php endforeach; ?>

                                </div>

                            </div>

                        </div>

                        <div class="max-w-37.5 w-full h-1.5 rounded-full bg-(--phthalo-green)/10 overflow-hidden mx-auto">

                            <div class="progressBar bg-(--phthalo-green) rounded-full overflow-hidden h-full duration-400 ease-in-out transition-all">



                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </section>

    <?php endif; ?>



    <?php



    $faqs = get_field('faqs_section') ?: [];



    $title_column = $faqs['title_column'] ?? [];

    $sub_title    = $title_column['section_sub_title'] ?? '';

    $title        = $title_column['section_title'] ?? '';



    $image = $faqs['image'] ?? null;



    $has_content =

        $sub_title ||

        $title ||

        $image;



    $faqsItems = get_theme_option_repeater_values('faq_items', get_the_ID());

    ?>

    <?php if ($has_content): ?>

        <section class="section-padding relative">

            <div class="container">

                <div class="lg:space-y-12.5 space-y-7.5">

                    <?php if ($sub_title || $title): ?>

                        <div class="text-center space-y-4 text-(--phthalo-green)">

                            <?php if ($sub_title): ?>

                                <p class="text-[13px] leading-[21px] tracking-[0.32px] font-semibold text-(--phthalo-green)/60">

                                    <?php echo esc_html($sub_title); ?>

                                </p>

                            <?php endif; ?>



                            <?php if ($title): ?>

                                <h2 class="font-normal text-[29px] leading-[39px] tracking-[0.32px]">

                                    <?php echo esc_html($title); ?>

                                </h2>

                            <?php endif; ?>

                        </div>

                    <?php endif; ?>

                    <div class="flex flex-col flex-wrap items-stretch md:flex-row md:space-x-7.5 xl:space-x-12.5">

                        <?php if ($image): ?>

                            <div class="hidden relative md:flex rounded-xl overflow-hidden md:w-[calc(50%-30px)] xl:w-[calc(50%-50px)] bg-(--phthalo-green) bg-cover bg-center"

                                style="background-image: url('<?php echo esc_url($image['url']); ?>');">

                                <div class="absolute inset-0 bg-[rgba(255,255,255,0.3)] clip-path-triangle opacity-100"></div>

                            </div>

                        <?php endif; ?>





                        <div class="w-full md:w-[50%]">

                            <div class="space-y-2.5" data-accordion="collapse" data-active-classes="pb-5 bg-white/50" data-inactive-classes="pb-5 bg-white/50">



                                <?php

                                if (!empty($faqsItems)) {

                                    $index = 0;

                                    foreach ($faqsItems as $item) :

                                        $isFirst = $index === 0 ? 'true' : 'false';

                                        $expandedClass = $isFirst === 'true' ? 'true' : 'false';

                                ?>

                                        <div class="accordion-item rounded-xl overflow-hidden shadow-[0_2px_4px_0_rgba(0,0,0,0.05)]">

                                            <p id="luxurious-heading-<?php echo $index + 1; ?>">

                                                <button type="button"

                                                    class="flex items-center justify-between gap-4 text-start w-full px-4 py-5 pb-4 cursor-pointer outline-0 bg-white transition-all duration-400"

                                                    data-accordion-target="#luxurious-body-<?php echo $index + 1; ?>"

                                                    aria-expanded="<?php echo $expandedClass; ?>"

                                                    aria-controls="luxurious-body-<?php echo $index + 1; ?>">

                                                    <span class="text-lg font-medium leading-[165%] text-(--phthalo-green)">

                                                        <?php echo esc_html($item['title']); ?>

                                                    </span>



                                                    <!-- Include accordion arrows -->

                                                    <?php

                                                    require get_template_directory() . '/inc/common-sections/accordian-arrow.php';

                                                    ?>

                                                </button>

                                            </p>

                                            <div id="luxurious-body-<?php echo $index + 1; ?>"

                                                class="hidden px-4 pb-5 bg-white transition-all duration-400"

                                                aria-labelledby="luxurious-heading-<?php echo $index + 1; ?>">

                                                <div class="text-sm leading-[165%] text-(--phthalo-green)/60 font-medium">

                                                    <?php echo esc_html($item['descriptions']); ?>

                                                </div>

                                            </div>

                                        </div>

                                <?php

                                        $index++;

                                    endforeach;
                                }

                                ?>

                            </div>

                        </div>

                    </div>

                </div>



                <div class="hidden md:block bg-[linear-gradient(to_right,_#E9EBF0,_rgba(223,_218,_199,_0.3))] aspect-square w-full max-w-[80%] absolute bottom-[-40%] right-[-30%] 2xl:bottom-[-50%] 2xl:right-[-33%] rounded-full pointer-events-none -z-10 rotate-90 animate-gradientMovement"></div>

        </section>

    <?php endif; ?>





</main>

<script>
    jQuery(document).ready(function() {

        // Only run if videos exist

        if (!jQuery('.videoPlayBtnWithFullScreen').length) {

            return;

        }

        jQuery('.videoPlayBtnWithFullScreen').each(function() {

            var $wrapper = jQuery(this);

            var video = $wrapper.find('video').get(0);

            if (!video) {

                return;

            }



            // Ensure autoplay works (especially on mobile)

            video.muted = true;

            video.playsInline = true;

            video.autoplay = true;

            video.controls = false;



            // Try autoplay safely

            var playPromise = video.play();

            if (playPromise !== undefined) {

                playPromise.catch(function() {});

            }



            // Click → Fullscreen

            $wrapper.on('click', function(e) {

                e.preventDefault();



                // Remove active from others (optional but recommended)

                jQuery('.videoPlayBtnWithFullScreen').removeClass('active');



                // Add active to current

                $wrapper.addClass('active');



                // Enable controls when entering fullscreen

                video.controls = true;



                // 🔥 RESTART VIDEO FROM BEGINNING

                video.currentTime = 0;



                // Unmute when entering fullscreen

                video.muted = false;

                video.play();



                // Fullscreen API handling

                if (video.requestFullscreen) {

                    video.requestFullscreen();

                } else if (video.webkitRequestFullscreen) {

                    video.webkitRequestFullscreen(); // Safari desktop

                } else if (video.webkitEnterFullscreen) {

                    video.webkitEnterFullscreen(); // iOS Safari

                } else if (video.msRequestFullscreen) {

                    video.msRequestFullscreen();

                }

            });

        });



        // Remove controls & active class when exiting fullscreen

        jQuery(document).on(

            'fullscreenchange webkitfullscreenchange webkitendfullscreen',

            function() {



                if (

                    document.fullscreenElement ||

                    document.webkitFullscreenElement

                ) {

                    return;

                }

                jQuery('.videoPlayBtnWithFullScreen').each(function() {

                    var video = jQuery(this).find('video').get(0);



                    if (!video) {

                        return;

                    }

                    video.controls = false;

                    video.muted = true;

                    jQuery(this).removeClass('active');

                });

            }

        );



    });
</script>

<script>
    jQuery(document).ready(function($) {



        /* =========================

           PAGE GUARD

        ========================== */

        const $wrapper = $('.reviewHomeSliderWrapper');

        if (!$wrapper.length) return;



        const $slider = $wrapper.find('.reviewSlider');

        const $items = $slider.find('.cartItem');

        const $progressBar = $wrapper.find('.progressBar');



        /* =========================

           CONFIG

        ========================== */

        const autoPlayDelay = 4000;

        const itemsPerStep = 1; // 👈 move 1 item at a time



        function getItemsPerView() {

            if (window.innerWidth < 640) return 1;

            if (window.innerWidth < 1024) return 2;

            return 3; // desktop

        }



        let itemsPerView = getItemsPerView();



        if ($items.length <= itemsPerView) return;



        let currentIndex = 0;

        let itemWidth = $items.outerWidth(true);

        let maxIndex = $items.length - itemsPerView;

        let autoPlayTimer;



        /* =========================

           UPDATE PROGRESS (CORRECT)

        ========================== */

        function updateProgress() {

            if (maxIndex <= 0) {

                $progressBar.css('width', '100%');

                return;

            }



            const progress = (currentIndex / maxIndex) * 100;

            $progressBar.css('width', progress + '%');

        }



        /* =========================

           GO TO SLIDE

        ========================== */

        function goTo(index) {

            currentIndex = Math.max(0, Math.min(index, maxIndex));



            $slider.stop().animate({

                    scrollLeft: currentIndex * itemWidth

                },

                400,

                'swing',

                updateProgress

            );

        }



        /* =========================

           AUTOPLAY

        ========================== */

        function startAutoPlay() {

            autoPlayTimer = setInterval(() => {

                if (currentIndex >= maxIndex) {

                    goTo(0);

                } else {

                    goTo(currentIndex + itemsPerStep);

                }

            }, autoPlayDelay);

        }



        function stopAutoPlay() {

            clearInterval(autoPlayTimer);

        }



        startAutoPlay();



        /* =========================

           TOUCH + MOUSE SWIPE

        ========================== */

        let startX = 0;

        let isDragging = false;



        $slider.on('mousedown touchstart', function(e) {

            stopAutoPlay();

            isDragging = true;



            startX = e.type === 'mousedown' ?

                e.pageX :

                e.originalEvent.touches[0].pageX;

        });



        $slider.on('mouseup touchend mouseleave', function(e) {

            if (!isDragging) return;

            isDragging = false;



            let endX = e.type === 'mouseup' ?

                e.pageX :

                e.originalEvent.changedTouches?.[0]?.pageX;



            if (!endX) return;



            const diff = endX - startX;



            if (Math.abs(diff) > 50) {

                if (diff < 0) {

                    goTo(currentIndex + itemsPerStep);

                } else {

                    goTo(currentIndex - itemsPerStep);

                }

            } else {

                goTo(currentIndex);

            }



            startAutoPlay();

        });



        /* =========================

           RESIZE HANDLING

        ========================== */

        $(window).on('resize', function() {

            itemsPerView = getItemsPerView();

            itemWidth = $items.outerWidth(true);

            maxIndex = $items.length - itemsPerView;

            goTo(currentIndex);

        });



        /* =========================

           INIT

        ========================== */

        updateProgress();

    });
</script>





<?php

get_footer();
