// cart-qty-monitor.js
jQuery(document).ready(function($) {
    if (!window.wp?.data) {
        console.warn('wp.data not loaded');
        return;
    }

    const { subscribe, select } = window.wp.data;
    const CART_STORE = 'wc/store/cart';

    let lastTotalQty = 0;

    subscribe(() => {
        const cart = select(CART_STORE).getCartData();
        if (!cart?.items) return;

        const totalQty = cart.items.reduce((sum, item) => sum + item.quantity, 0);

        if (totalQty !== lastTotalQty) {
            const direction = totalQty > lastTotalQty ? 'increased' : 'decreased';
        $(document.body).trigger('wc_fragment_refresh');
            console.log('Cart updated – total qty:', totalQty, cart);
            lastTotalQty = totalQty;
        }
    }, CART_STORE);
});