<?php
/**
 * Blog Card Template
 * Expected vars:
 * $blog_id (WP_Post ID)
 */
$blog_id = isset($args['blog_id']) ? (int) $args['blog_id'] : 0;
if (! $blog_id) {
    return;
}
?>
<?php if ($blog_id): 
$image = get_the_post_thumbnail_url($blog_id, 'full');
$image = $image ? $image : get_template_directory_uri() . '/assets/images/noimg.webp';
    ?>
<a href="<?php echo get_permalink($blog_id); ?>"
   class="group m-2.5 xl:m-3 xl:w-[calc(33.3333%-24px)] lg:w-[calc(33.3333%-20px)] sm:w-[calc(50%-20px)] w-[calc(100%-20px)] duration-400 space-y-5">

    <div class="aspect-video rounded-xl overflow-hidden border border-(--queen-pink) group-hover:border-(--phthalo-green) duration-400">
        <img
            class="object-cover object-center w-full h-full duration-400 group-hover:scale-110"
            src="<?php echo esc_url($image); ?>"
            alt="<?php echo esc_attr(get_the_title($blog_id)); ?>">
    </div>

    <div class="space-y-4 leading-[150%]">
        <div class="space-y-2.5">
            <h6 class="flex items-center text-(--phthalo-green)/60 text-sm space-x-1.5">
                <span><?php echo esc_html(get_the_category($blog_id)[0]->name ?? 'Build'); ?></span>
                <?php require get_template_directory() . '/assets/icons/dot-icon.php'; ?>
                <span><?php echo get_the_date('d M Y', $blog_id); ?></span>
            </h6>

            <h2 class="font-light text-(--phthalo-green) text-xl lg:text-[26px] leading-[120%] line-clamp-2 font-montserrat">
                <?php echo esc_html(get_the_title($blog_id)); ?>
            </h2>

            <div class="font-medium group-hover:text-(--phthalo-green) text-(--phthalo-green)/60 line-clamp-3 duration-400 text-sm lg:text-base">
                <?php echo esc_html(get_the_excerpt($blog_id)); ?>
            </div>
        </div>

        <h5 class="text-(--phthalo-green) text-sm pb-1.5 flex items-center border-b border-b-(--phthalo-green) space-x-1.5 font-normal w-max">
            <span class="font-degila text-nowrap">Read more</span>
            <span class="group-hover:pl-2 duration-400">
                <?php require get_template_directory() . '/assets/icons/right-arrow.php'; ?>
            </span>
        </h5>
    </div>
</a>
<?php endif; ?>