<?php
/**
 * Dynamic grid items for blog tabs
 * DO NOT change HTML structure or classes
 */

// Vars from parent template
$grid_limit    = (int) get_query_var('grid_limit');
$grid_type     = get_query_var('grid_type');       // popular | recent | trendy
$grid_category = (int) get_query_var('grid_category');
$current_id    = get_the_ID();

// Fallback safety
if (!$grid_limit) {
    $grid_limit = 3;
}

// Base query args
$args = [
    'post_type'      => 'post',
    'posts_per_page' => $grid_limit,
    'post__not_in'   => [$current_id],
    'post_status'   => 'publish',
];

// Tab-specific logic
switch ($grid_type) {

    case 'popular':
        $args['orderby'] = 'comment_count';
        $args['order']   = 'DESC';
        break;

    case 'trendy':
        if ($grid_category) {
            $args['cat'] = $grid_category;
        }
        $args['orderby'] = 'date';
        $args['order']   = 'DESC';
        break;

    case 'recent':
    default:
        $args['orderby'] = 'date';
        $args['order']   = 'DESC';
        break;
}

// Run query
$query = new WP_Query($args);
?>

<?php if ($query->have_posts()) : ?>
    <?php while ($query->have_posts()) : $query->the_post(); ?>

        <?php
        $thumb = get_the_post_thumbnail_url(get_the_ID(), 'thumbnail');
        ?>

        <a
            href="<?php the_permalink(); ?>"
            class="group bg-(--light-khaki) p-2 rounded-lg overflow-hidden
                   flex items-center space-x-4 cursor-pointer">

            <div class="w-17.5 h-17.5 min-w-17.5 rounded-sm overflow-hidden">
                <?php if ($thumb) : ?>
                    <img
                        class="object-cover object-center w-full h-full duration-400 group-hover:scale-110"
                        src="<?php echo esc_url($thumb); ?>"
                        alt="<?php the_title_attribute(); ?>">
                <?php endif; ?>
            </div>

            <div class="w-full space-y-2">
                <h3 class="font-semibold text-(--phthalo-green) text-sm leading-none font-montserrat">
                    <?php the_title(); ?>
                </h3>

                <h6 class="flex items-center font-medium text-(--phthalo-green)/60
                           text-xs space-x-1.5 leading-none">
                    <?php require get_template_directory() . '/assets/icons/watch-icon.php'; ?>
                    <span class="font-montserrat">
                        <?php echo esc_html(get_the_date('d F Y')); ?>
                    </span>
                </h6>
            </div>

        </a>

    <?php endwhile; ?>
<?php endif; ?>

<?php wp_reset_postdata(); ?>
