<?php

/*
Template Name: Page Blog Details
Description: A custom blog details page template
*/

get_header();
?>

<main class="overflow-hidden relative">
    <?php require get_template_directory() . '/inc/common-sections/banner-ellipse.php'; ?>
    <section class="section-padding md:pt-[145px]! pt-[130px]! relative">
        <div class="container">
            <?php require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php'; ?>
        </div>
        <div class="container">
            <div class="flex flex-col flex-wrap md:flex-row md:space-x-7.5 xl:space-x-12.5 space-y-7.5 md:space-y-0">
                <div class="md:w-[calc(100%-324px)] xl:w-[calc(100%-344px)] w-full space-y-5">
                    <div class="space-y-2.5">
                        <h1 class="font-light text-(--phthalo-green) text-2xl lg:text-[40px] leading-[120%] line-clamp-3 font-montserrat">
                            Rooted in Nature. Grounded in Integrity
                        </h1>
                        <h6 class="flex items-center text-(--phthalo-green)/60 text-sm space-x-1.5">
                            <span>Build</span>
                            <?php require get_template_directory() . '/assets/icons/dot-icon.php'; ?>
                            <span>15 Januari 2026</span>
                        </h6>
                    </div>
                    <div class="space-y-5">
                        <div class="aspect-video rounded-xl overflow-hidden border border-(--queen-pink) w-full">
                            <img
                                class="object-cover object-center w-full h-full duration-400 group-hover:scale-110"
                                src="<?php echo get_template_directory_uri(); ?>/assets/images/blog3.webp"
                                alt="Blog details image">
                        </div>
                        <div
                            class="lg:space-y-5 space-y-4 font-medium text-sm text-justify text-(--phthalo-green)/60 leading-[165%] [&_a]:underline 
                                [&_a]:hover:opacity-65 [&_a]:duration-400 
						        [&_h1]:mt-8 [&_h1:first-child]:mt-0 
						        [&_h2]:mt-8 [&_h2:first-child]:mt-0 
						        [&_h2]:text-lg md:[&_h2]:text-2xl [&_h2]:text-(--phthalo-green)
						        [&_h3]:text-lg md:[&_h3]:text-2xl [&_h3]:text-(--phthalo-green)
						        [&_h4]:text-lg md:[&_h4]:text-2xl [&_h4]:text-(--phthalo-green)
						        [&_ul]:space-y-2.5 [&_ul]:pl-8 [&_li]:list-disc
						        [&_ol]:space-y-2.5 [&_ol]:pl-8
                                ">
                            <p>
                                Lorem ipsum dolor sit amet consectetur adipisicing elit. Optio delectus impedit nemo deserunt numquam, esse neque ut magni, ratione harum velit! Vel neque debitis dolores iusto, voluptatibus quibusdam sapiente pariatur dolorum vitae magni hic necessitatibus quisquam sunt voluptas quam! Quibusdam soluta architecto vero, tempore a eum sequi delectus unde vel explicabo, velit nisi numquam voluptatem? Totam, modi dolore? Excepturi voluptate et, vero iste in maiores? Temporibus commodi voluptas aut officiis?
                            </p>
                            <h2>
                                Lorem ipsum dolor sit amet consectetur adipisicing elit. Nostrum voluptas ipsa placeat.
                            </h2>
                            <p>
                                Lorem ipsum dolor sit amet consectetur adipisicing elit. Fuga ea a molestias hic deleniti illo laborum quidem quam minus, commodi officia sunt sequi facilis ipsam quae beatae rerum harum corporis magni nulla veritatis pariatur dignissimos nobis reiciendis! Nostrum id eius provident laborum ullam excepturi asperiores, explicabo atque sit. Itaque, facere.
                            </p>
                            <p>
                                Lorem ipsum dolor, sit amet consectetur adipisicing elit. Tempora voluptates iure hic dolore doloribus facere corrupti pariatur! Reiciendis unde numquam maiores temporibus fugit dolores accusamus praesentium cumque odio magnam non eligendi quod, cum eos itaque tenetur quis commodi eveniet. Reiciendis maiores maxime iusto voluptatum qui quis quos libero omnis assumenda! Ratione porro facilis, delectus accusantium saepe quidem aut perspiciatis laboriosam velit, nesciunt eius. Nemo natus iusto quo repellat atque necessitatibus sit blanditiis vel veritatis dolorem voluptatum placeat dolorum suscipit aliquid autem quisquam quos ipsum illo cum, rerum saepe molestiae porro officia. Harum autem rem vel fugiat, vitae placeat dolorem esse.
                            </p>
                            <ul>
                                <li>Lorem ipsum dolor sit amet.</li>
                                <li>Lorem ipsum dolor sit amet consectetur adipisicing elit. Amet, velit commodi!</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="md:w-[294px] w-full lg:space-y-12.5 space-y-7.5">
                    <div class="space-y-5">
                        <h3 class="text-lg font-semibold leading-[100%] font-montserrat">
                            Social Network
                        </h3>
                        <div>
                            <div class="-m-1">
                                <div class="flex flex-wrap">
                                    <?php
                                    $socials = [
                                        [
                                            'url'   => '#',
                                            'icon'  => 'social-instagram.php',
                                            'name'  => 'Instagram',
                                            // Official Instagram gradient
                                            'bg'    => 'linear-gradient(45deg, #F58529, #DD2A7B, #8134AF, #515BD4)',
                                        ],
                                        [
                                            'url'   => '#',
                                            'icon'  => 'social-twitter.php',
                                            'name'  => 'Twitter',
                                            'bg'    => '#1DA1F2',
                                        ],
                                        [
                                            'url'   => '#',
                                            'icon'  => 'social-facebook.php',
                                            'name'  => 'Facebook',
                                            'bg'    => '#1877F2',
                                        ],
                                        [
                                            'url'   => '#',
                                            'icon'  => 'social-youtube.php',
                                            'name'  => 'YouTube',
                                            'bg'    => '#FF0000',
                                        ],
                                        [
                                            'url'   => '#',
                                            'icon'  => 'social-pinterest.php',
                                            'name'  => 'Pinterest',
                                            'bg'    => '#E60023',
                                        ],
                                        [
                                            'url'   => '#',
                                            'icon'  => 'social-linkedin.php',
                                            'name'  => 'LinkedIn',
                                            'bg'    => '#0A66C2',
                                        ],
                                    ];
                                    ?>


                                    <?php foreach ($socials as $social) : ?>
                                        <a href="<?php echo esc_url($social['url']); ?>"
                                            target="_blank"
                                            rel="noopener noreferrer"
                                            class="w-[calc(50%-8px)] flex items-center justify-start rounded-lg p-1.5 overflow-hidden space-x-2 m-1 bg-(--light-khaki) min-h-11 duration-400 hover:bg-(--phthalo-green) hover:text-white text-sm">
                                            <div
                                                class="rounded-sm h-8 w-8 min-w-8 flex items-center justify-center [&_svg]:h-5 [&_svg]:w-5 [&_svg]:fill-white"
                                                style="background: <?php echo esc_attr($social['bg']); ?>;">
                                                <?php
                                                include get_template_directory() . '/assets/icons/' . esc_attr($social['icon']);
                                                ?>
                                            </div>

                                            <span>
                                                <?php echo esc_html($social['name']); ?>
                                            </span>
                                        </a>
                                    <?php endforeach; ?>

                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                    /**
                     * Blog Tabs Section (Static Grid)
                     */

                    // Tab configuration
                    $tabs = [
                        [
                            'id'    => 'popular',
                            'label' => 'Popular',
                            'limit' => 4,
                        ],
                        [
                            'id'    => 'recent',
                            'label' => 'Recent',
                            'limit' => 2,
                        ],
                        [
                            'id'    => 'trendy',
                            'label' => 'Trendy',
                            'limit' => 3,
                        ],
                    ];
                    ?>

                    <div class="space-y-5">

                        <!-- Tabs -->
                        <div
                            class="flex text-sm font-semibold leading-[100%] text-center rounded-xl overflow-hidden bg-(--queen-pink)"
                            id="default-tab"
                            data-tabs-toggle="#blogTab"
                            data-tabs-active-classes="text-(--phthalo-green)"
                            data-tabs-inactive-classes="text-(--phthalo-green)/60"
                            role="tablist">

                            <?php foreach ($tabs as $index => $tab) : ?>
                                <button
                                    class="inline-block min-h-11.5 w-full px-1 py-2.5
                    <?php echo $index !== array_key_last($tabs) ? 'border-r border-(--bg2)' : ''; ?>
                    text-(--phthalo-green)/60 hover:text-(--phthalo-green)
                    uppercase duration-400 cursor-pointer text-nowrap"
                                    id="tab-<?php echo esc_attr($tab['id']); ?>"
                                    data-tabs-target="#<?php echo esc_attr($tab['id']); ?>"
                                    type="button"
                                    role="tab"
                                    aria-controls="<?php echo esc_attr($tab['id']); ?>"
                                    aria-selected="false">
                                    <?php echo esc_html($tab['label']); ?>
                                </button>
                            <?php endforeach; ?>

                        </div>

                        <!-- Tab Panels -->
                        <div id="blogTab">
                            <?php foreach ($tabs as $tab) : ?>
                                <div
                                    class="hidden space-y-3"
                                    id="<?php echo esc_attr($tab['id']); ?>"
                                    role="tabpanel"
                                    aria-labelledby="tab-<?php echo esc_attr($tab['id']); ?>">

                                    <?php
                                    // Pass limit to grid template
                                    set_query_var('grid_limit', (int) $tab['limit']);
                                    get_template_part('template-parts/blog-tabs/tab-grid');

                                    ?>

                                </div>
                            <?php endforeach; ?>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </section>
</main>

<?php
get_footer();
