<?php

/*
Template Name: Page Contact Us
Description: A custom contact page template
*/

get_header();
?>

<main class="overflow-hidden relative">
    <?php require get_template_directory() . '/inc/common-sections/banner-ellipse.php'; ?>

    <?php

    $contact = get_field('contact_section') ?: [];
    $info = get_theme_option_repeater_values('contact_info', get_the_ID());

    $sub_title      = $contact['sub_title'] ?? '';
    $title          = $contact['title'] ?? '';
    $description    = $contact['short_description'] ?? '';

    $has_content =
        $sub_title ||
        $title || $info;
    ?>
    <?php if ($has_content): ?>
        <section class="section-padding md:pt-[145px]! pt-[130px]! relative">
            <div class="container">
                <?php require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php'; ?>
            </div>
            <div class="container">
                <div class="flex flex-wrap flex-col md:flex-row md:space-x-7.5 lg:space-x-12.5 md:space-y-0">
                    <div class="lg:w-[calc(45.3%-50px)] md:w-[calc(45.3%-30px)] lg:p-6 md:space-y-9">
                        <div class="w-full md:space-y-4 space-y-3 text-(--phthalo-green) leading-[165%]">
                            <?php if ($sub_title): ?>
                                <div class="flex items-center space-x-2.5">
                                    <div class="w-5 min-w-5 h-0.5 bg-(--phthalo-green)/80 -mt-0.5">
                                    </div>
                                    <h3 class="text-lg leading-[100%]">
                                        <?php echo esc_html($sub_title); ?>
                                    </h3>
                                </div>
                            <?php endif; ?>

                            <div class="space-y-3 md:space-y-5 [&_h1]:text-2xl [&_h1]:font-semibold">
                                <?php if ($title): ?>
                                    <h1>
                                        <?php echo esc_html($title); ?>
                                    </h1>
                                <?php endif; ?>
                                <?php if ($description): ?>
                                    <div class="text-sm text-(--phthalo-green)/60  font-medium">
                                        <?php echo esc_html($description); ?>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>

                        <?php if (!empty($info)) { ?>
                            <div class="w-full md:space-y-6 space-y-4 text-(--phthalo-green) font-medium md:border-0 border-y border-(--queen-pink) md:m-0 md:p-0 my-7.5 py-7.5">
                                <?php foreach ($info as $item) :
                                    $url = !empty($item['url']) ? esc_url($item['url']) : 'javascript:void(0)';
                                ?>
                                    <a
                                        class="duration-400 hover:text-(--phthalo-green)/60  space-x-2 flex items-start"
                                        href="<?php echo $url; ?>">
                                        <!-- Icon -->
                                        <?php echo wp_get_attachment_image($item['icon'], 'full', false, [
                                            'class' => 'mt-0.5 h-5 w-5 object-contain',
                                            'alt' => 'Icon'
                                        ]);
                                        ?>
                                        <span>
                                            <?php echo $item['text']; ?>
                                        </span>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="md:w-[54.7%]">
                        <div id="contactForm">
                            <?php echo do_shortcode('[forminator_form id="503"]'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
</main>

<?php
get_footer();
