<?php

/*
Template Name: Page Blog
Description: A custom blog page template
*/

get_header();
?>

<main class="overflow-hidden relative">
    <?php require get_template_directory() . '/inc/common-sections/banner-ellipse.php'; ?>
    <section class="section-padding md:pt-[145px]! pt-[130px]! relative">
        <div class="container">
            <?php require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php'; ?>
        </div>
      <div class="container">
    <div class="lg:space-y-12.5 space-y-7.5">

        <?php
      
        $featured_query = new WP_Query([
            'post_type'      => 'post',
              'posts_per_page' => 1,
             'post__in'       => (array) get_field('blog_page_top_post', THEME_SETTINGS_ID),
            'orderby'        => 'post__in',
        ]);

        if ($featured_query->have_posts()):
            while ($featured_query->have_posts()): $featured_query->the_post();
        ?>

        <a href="<?php the_permalink(); ?>" class="w-full inline-block relative group">
            <div class="bg-(--primary-marigold)/20 min-h-100 rounded-xl md:w-[calc(100%-68px)] p-3 sm:p-6 lg:py-12 flex flex-col-reverse md:flex-row md:items-center space-y-5 space-y-reverse md:space-y-0 md:space-x-7.5 xl:space-x-12.5 flex-wrap">

                <div class="md:w-[calc(53.7%-30px)] xl:w-[calc(53.7%-50px)] space-y-4 leading-[150%]">
                    <div class="space-y-2.5">
                        <h6 class="flex items-center text-(--phthalo-green)/60 text-sm space-x-1.5">
                            <span><?php echo esc_html(get_the_category()[0]->name ?? 'Build'); ?></span>
                            <?php require get_template_directory() . '/assets/icons/dot-icon.php'; ?>
                            <span><?php echo get_the_date('d M Y'); ?></span>
                        </h6>

                        <h1 class="font-light text-(--phthalo-green) text-2xl lg:text-[40px] leading-[120%] line-clamp-3 font-montserrat">
                            <?php the_title(); ?>
                        </h1>

                        <div class="font-medium group-hover:text-(--phthalo-green) text-(--phthalo-green)/60 line-clamp-3 duration-400 text-sm lg:text-base">
                            <?php the_excerpt(); ?>
                        </div>
                    </div>

                    <h5 class="text-(--phthalo-green) text-sm pb-1.5 flex items-center border-b border-b-(--phthalo-green) space-x-1.5 font-normal w-max">
                        <span class="font-degila text-nowrap">Read more</span>
                        <span class="group-hover:pl-2 duration-400">
                            <?php require get_template_directory() . '/assets/icons/right-arrow.php'; ?>
                        </span>
                    </h5>
                </div>

                <div class="md:w-[46.3%]">
                    <div class="md:w-[calc(100%+92px)] md:-mr-[92px]">
                        <div class="aspect-video rounded-xl overflow-hidden border border-(--queen-pink) group-hover:border-(--phthalo-green) duration-400">
                            <img
                                class="object-cover object-center w-full h-full duration-400 group-hover:scale-110"
                                src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>"
                                alt="<?php the_title_attribute(); ?>">
                        </div>
                    </div>
                </div>

            </div>
        </a>

        <?php endwhile; wp_reset_postdata(); endif; ?>

        <!-- GRID BLOGS -->
        <div>
            <div>
                <div class="-m-2.5 xl:-m-3">
                    <div class="flex flex-wrap justify-center">

                        <?php
                        $blog_query = new WP_Query([
                            'post_type'      => 'post',
                            'posts_per_page' => 6,
                            'orderby' => 'date',
                            'order'   => 'DESC',
                            'post__not_in'   => (array) get_field('blog_page_top_post', THEME_SETTINGS_ID),
                           
                        ]);

                        if ($blog_query->have_posts()):
                            while ($blog_query->have_posts()):
                                $blog_query->the_post();
                                $blog_id = get_the_ID();
                                get_template_part('template-parts/blog/blog-card', null, ['blog_id' => $blog_id]);
                            endwhile;
                            wp_reset_postdata();
                        endif;
                        ?>

                    </div>
                </div>
            </div>
            <?php
            $total_posts = wp_count_posts('post')->publish;
            $featured_posts = (array) get_field('blog_page_top_post', THEME_SETTINGS_ID);
            $featured_posts = array_filter(array_map('intval', $featured_posts));

            $total_posts = wp_count_posts('post')->publish;
            $total_posts = $total_posts - count($featured_posts);

            $posts_per_page = 1; // SAME as grid query
            $total_pages = ceil($total_posts / $posts_per_page);
            ?>
            <?php if ($total_pages > 6): ?>
            <div class="text-center mt-7.5 flex justify-center">
                <a href="#" class="js-load-more btn-secondary w-full sm:w-auto" data-page="1" data-max="<?php echo esc_attr($total_pages); ?>">
                    <span class="relative z-10">View More</span>
                </a>
            </div>
            <?php endif; ?>
        </div>

    </div>
</div>

    </section>
</main>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const loadMoreBtn = document.querySelector('.js-load-more');
    if (!loadMoreBtn) return;

    loadMoreBtn.addEventListener('click', function (e) {
        e.preventDefault();

        let page = parseInt(this.dataset.page);
        let max  = parseInt(this.dataset.max);

        this.classList.add('opacity-50', 'pointer-events-none');

        const formData = new FormData();
        formData.append('action', 'load_more_blogs');
        formData.append('page', page);

        fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
            method: 'POST',
            body: formData
        })
        .then(res => res.text())
        .then(html => {

            if (html.trim() !== '') {
                document.querySelector('.flex.flex-wrap.justify-center')
                    .insertAdjacentHTML('beforeend', html);

                loadMoreBtn.dataset.page = page + 1;
                loadMoreBtn.classList.remove('opacity-50', 'pointer-events-none');
            }

            if ((page + 1) >= max) {
                loadMoreBtn.remove();
            }
        });
    });
});
</script>

<?php
get_footer();
