<?php

/*
Template Name: Page About Us
Description: A custom about page template
*/

get_header();
?>

<main class="overflow-hidden relative">
    <?php require get_template_directory() . '/inc/common-sections/banner-ellipse.php'; ?>

    <?php
    // Fetch the ACF field for 'about_us_section'
    $about = get_field('about_us_section');
    ?>

    <section class="section-padding md:pt-[145px]! pt-[130px]! relative">
        <div class="container">
            <?php require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php'; ?>
        </div>
        <div class="container">
            <div class="lg:space-y-12.5 space-y-7.5">
                <div class="text-center">
                    <?php if ($about['title']) { ?>
                        <h1 class="font-normal uppercase text-4xl sm:text-3xl lg:text-[46px] leading-[160%] sm:leading-[140%] lg:leading-[129%] text-(--phthalo-green)">
                            <?php echo esc_html($about['title']); ?>
                        </h1>
                    <?php } ?>
                </div>

                <div class="flex md:flex-row flex-col flex-wrap md:space-x-7.5 xl:space-x-12.5 space-y-7.5 md:space-y-0">
                    <!-- Left side content -->
                    <div class="md:w-[calc(70%-30px)] xl:w-[calc(70%-50px)] w-full space-y-5">
                        <?php
                        // Get left side content (image and description)
                        $left_content = $about['left_side_content'];
                        $img = $left_content['image'];
                        $description = $left_content['descriptions'];
                        ?>

                        <div class="aspect-video rounded-xl overflow-hidden border border-(--queen-pink) w-full">
                            <?php echo wp_get_attachment_image($img, 'full', false, [
                                'class' => 'object-contain object-center w-full h-full',
                                'alt' => 'Left side image'
                            ]);
                            ?>
                        </div>

                        <div class="lg:space-y-5 space-y-4 font-medium text-sm text-justify text-(--phthalo-green)/60 leading-[165%]">
                            <?php echo wp_kses_post($description); ?>
                        </div>
                    </div>

                    <!-- Right side content -->
                    <div class="md:w-[30%] w-full space-y-5">
                        <?php
                        // Get right side content (image and description)
                        $right_content = $about['right_side_content'];
                        $img = $right_content['image'];
                        $description = $right_content['descriptions'];
                        ?>

                        <div class="lg:space-y-5 space-y-4 font-medium text-sm text-justify text-(--phthalo-green)/60 leading-[165%]">
                            <?php echo wp_kses_post($description); ?>
                        </div>

                        <div class="aspect-square rounded-xl overflow-hidden w-full">

                            <?php echo wp_get_attachment_image($img, 'full', false, [
                                'class' => 'object-contain object-center w-full h-full',
                                'alt' => 'Right side image'
                            ]);
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <?php

    $our_story = get_field('our_story_section') ?: [];
    $storys = get_theme_option_repeater_values('story_info', get_the_ID());

    $sub_title    = $our_story['sub_title'] ?? '';
    $title        = $our_story['title'] ?? '';

    $has_content =
        $sub_title ||
        $title || $storys;
    ?>
    <?php if ($has_content): ?>
        <section class="section-padding pt-0!">
            <div class="container">
                <div class="lg:space-y-12.5 space-y-7.5">
                    <div class="flex md:flex-row flex-col flex-wrap md:space-x-7.5 xl:space-x-12.5 space-y-7.5 md:space-y-0">
                        <?php if ($sub_title): ?>
                            <div class="md:w-[30%] w-full space-y-5">
                                <p class="text-[13px] leading-[21px] tracking-[0.32px] font-semibold text-(--phthalo-green)/60">
                                    <?php echo esc_html($sub_title); ?>
                                </p>
                            </div>
                        <?php endif; ?>
                        <div class="md:w-[calc(70%-30px)] xl:w-[calc(70%-50px)] w-full lg:space-y-12.5 space-y-7.5">
                            <?php if ($title): ?>
                                <h2 class="font-normal text-[29px] leading-[39px] tracking-[0.32px]">
                                    <?php echo esc_html($title); ?>
                                </h2>
                            <?php endif; ?>
                            <div class="xl:space-y-12.5 space-y-5">
                                <?php
                                if (!empty($storys)) {
                                    foreach ($storys as $item) :
                                ?>
                                        <div class="flex flex-col lg:flex-row lg:space-x-4 lg:space-y-0 space-y-2.5">

                                            <div class="w-full">
                                                <h6 class="text-[13px] leading-[21px] tracking-[0.32px] font-semibold text-(--phthalo-green)/60 font-montserrat">
                                                    <?php echo esc_html($item['title']); ?>
                                                </h6>
                                            </div>

                                            <div class="w-full lg:space-y-5 space-y-4 font-normal text-sm text-justify text-(--phthalo-green)/60 leading-[165%]">
                                                <?php echo esc_html($item['description']); ?>
                                            </div>
                                        </div>
                                <?php
                                    endforeach;
                                } ?>



                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
</main>

<?php
get_footer();
