<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luxurious_Skincare_Encoder_IT
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>
<?php
$logo = get_field('site_logo', THEME_SETTINGS_ID);
$mobileLogo = get_field('mobile_logo', THEME_SETTINGS_ID);
?>

<body id="luxuriousBody" <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">


		<?php
		require get_template_directory() . '/inc/header-part/sidebar.php';
		?>
		<?php $menu_items = get_primary_menu_items();  ?>
		<header class="luxuriousHeader fixed top-0 right-0 left-0 z-20 lg:py-[15px] py-2.5 bg-(--phthalo-green) lg:bg-transparent transition-all duration-400 min-h-20.5">
			<div class="header-backdrop absolute inset-0 bg-[rgba(255,255,255,0)] shadow-[0_4px_30px_rgba(0,0,0,0.1)] backdrop-blur-[6px] -z-1 transition-all duration-400 opacity-0 in-[.is-sticky]:opacity-100 in-[.is-sticky]:backdrop-blur-[6px]"></div>
			<div class="container">
				<div class="flex items-center justify-between">



					<?php if ($logo): ?>
						<a href="<?php echo esc_url(site_url()); ?>"
							class="items-center max-w-[127px] lg:flex hidden">
							<?php echo wp_get_attachment_image(
								$logo['ID'],
								'full',
								false,
								[
									'class' => 'w-full h-auto headerLogo',
									'alt'   => esc_attr(get_bloginfo('name')),
								]
							); ?>
						</a>
					<?php endif; ?>

					<nav class="luxuriousMainNav flex items-center justify-between lg:justify-start space-x-11.5 lg:space-x-2.5 lg:static fixed bottom-0 right-0 left-0 z-20 scrollSlider hide-scrollbar overflow-x-auto lg:bg-transparent bg-white px-6 py-1 lg:p-0">
						<?php foreach ($menu_items as $item):
							$is_active = false;

							// Home
							if (is_front_page() && $item->url === home_url('/')) {
								$is_active = true;
							}

							// Normal pages
							elseif (is_page() && get_permalink() === $item->url) {
								$is_active = true;
							}

							// Woo Shop page
							elseif (function_exists('is_shop') && is_shop() && $item->url === wc_get_page_permalink('shop')) {
								$is_active = true;
							}

							// Single product (optional: keep Shop active)
							elseif (function_exists('is_product') && is_product() && $item->url === wc_get_page_permalink('shop')) {
								$is_active = true;
							}
						?>
							<a
								class="<?php echo $is_active ? 'active' : ''; ?> text-(--phthalo-green) font-semibold capitalize lg:px-5 xl:px-7.5 py-2.5 [&.active]:border-(--primary-marigold) [&.active]:text-(--primary-marigold) hover:border-(--primary-marigold) hover:text-(--primary-marigold) lg:border border-transparent rounded-full flex flex-col-reverse items-center justify-center duration-400 [&_svg]:w-7 [&_svg]:h-7 [&_svg]:mb-1 [&_svg]:lg:hidden"
								href="<?php echo esc_url($item->url); ?>">
								<span class="text-nowrap">
									<?php echo esc_html($item->title); ?>
								</span>


								<?php
								// Optional icon include based on slug
								$slug = sanitize_title($item->title);
								$icon = get_template_directory() . "/assets/icons/menu-{$slug}.php";

								if (file_exists($icon)) {
									require $icon;
								}
								?>
							</a>

						<?php endforeach; ?>
					</nav>

					<div class="w-full lg:w-auto flex items-center justify-between lg:justify-end lg:space-x-8">
						<div class="flex items-center space-x-3 lg:space-x-8">
							<a
								href="<?php echo site_url('cart'); ?>"
								class="cart-target p-1 text-(--primary-marigold) lg:text-(--phthalo-green) lg:hover:text-(--primary-marigold) cursor-pointer duration-400 relative">
								<span class="bg-(--primary-marigold) rounded-full h-4 min-w-4 flex items-center justify-center absolute -top-0.5 -right-0.5 text-(--phthalo-green) text-center text-[10px] font-semibold py-0.5 px-1">
									<?php echo WC()->cart->get_cart_contents_count(); ?>
								</span>
								<!-- Icon -->
								<?php require get_template_directory() . '/assets/icons/cart-icon.php'; ?>
							</a>

							<?php $account_url = wc_get_page_permalink('myaccount'); ?>
							<a
								href="<?php echo esc_url($account_url); ?>"
								class="p-1 text-(--primary-marigold) lg:text-(--phthalo-green) lg:hover:text-(--primary-marigold) cursor-pointer duration-400 relative"
								aria-label="My Account">
								<!-- Icon -->
								<?php require get_template_directory() . '/assets/icons/my-account-icon.php'; ?>
							</a>
						</div>

						<?php if ($mobileLogo): ?>
							<a href="<?php echo esc_url(site_url()); ?>"
								class="flex items-center max-w-60 w-full lg:hidden -mb-11 min-h-28 
							bg-(--phthalo-green) rounded-b-full">
								<?php echo wp_get_attachment_image(
									$mobileLogo['ID'],
									'full',
									false,
									[
										'class' => 'max-w-[125px]! mx-auto',
										'alt'   => esc_attr(get_bloginfo('name')),
									]
								); ?>
							</a>
						<?php endif; ?>
						<div class="min-w-19 lg:min-w-auto flex justify-end">
							<button class="p-1 text-(--primary-marigold) lg:text-(--phthalo-green) lg:hover:text-(--primary-marigold) cursor-pointer duration-400"
								data-drawer-target="sideCartDrawer" data-drawer-show="sideCartDrawer" data-drawer-placement="right" aria-controls="sideCartDrawer" data-drawer-body-scrolling="false">
								<!-- Icon -->
								<?php require get_template_directory() . '/assets/icons/menu-bar.php'; ?>
							</button>
						</div>
					</div>

				</div>
			</div>
		</header>


		<script>
			jQuery(document).ready(function() {

				if (jQuery(".luxuriousHeader").length) {

					const header = jQuery(".luxuriousHeader");
					const toggleClass = "is-sticky";
					const scrollLimit = 100;

					// Check scroll position on page load
					const currentScroll = jQuery(window).scrollTop();
					if (currentScroll > scrollLimit) {
						header.addClass(toggleClass); // Add `is-sticky` if already scrolled down
					}

					// Listen for scroll events
					jQuery(window).on("scroll", function() {
						const currentScroll = jQuery(this).scrollTop();

						if (currentScroll > scrollLimit) {
							header.addClass(toggleClass);
						} else {
							header.removeClass(toggleClass);
						}
					});
				}

			});
		</script>