<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luxurious_Skincare_Encoder_IT
 */

$footer_social_area = get_theme_option_repeater_values('footer_social_area');
?>

<div class="in-[.home]:hidden! hidden justify-around fixed inset-0 -z-10">
    <?php for ($i = 0; $i < 4; $i++): ?>
        <div class="w-px bg-(--queen-pink) h-full"></div>
    <?php endfor; ?>
</div>


<div class="in-[.page-template-page-shop]:hidden! flex flex-col justify-end fixed right-4 z-20 lg:top-1/2 lg:-translate-y-1/2 bottom-35 lg:bottom-[unset] space-y-2.5 overflow-hidden max-w-12.5">
    <div class="sidePanelContainer duration-400">
        <!-- Include certifications -->
        <?php
        require get_template_directory() . '/inc/common-sections/certifications.php';
        ?>
    </div>
    <button class="sm:hidden sidePanelToggleBtn text-(--primary-marigold) flex justify-end cursor-pointer hover:opacity-65 [&_svg]:duration-400 [&_svg]:transition-all [&.active_svg]:rotate-y-180">
        <?php include get_template_directory() . '/assets/icons/sidePanelArrow.php'; ?>
    </button>
</div>
<script>
    jQuery(function($) {

        var btn = $('.sidePanelToggleBtn');
        var panel = $('.sidePanelContainer');

        if (!btn.length || !panel.length) return;

        // Load state
        if (localStorage.getItem('sidePanelState') === 'closed') {
            panel.addClass('translate-x-full');
            btn.addClass('active');
        }

        btn.on('click', function() {
            panel.toggleClass('translate-x-full');
            btn.toggleClass('active');

            localStorage.setItem(
                'sidePanelState',
                panel.hasClass('translate-x-full') ? 'closed' : 'open'
            );
        });

    });
</script>


<div class="shopButtonsContainer hidden fixed bottom-[84px] lg:bottom-0 left-0 right-0 z-15 lg:flex items-center justify-center 
lg:p-4 duration-400 translate-y-full
md:space-x-4.5">
    <div class="absolute inset-0 bg-[rgba(255,255,255,0)] shadow-[0_4px_30px_rgba(0,0,0,0.1)] backdrop-blur-[6px] -z-1 transition-all duration-400 h-full w-full">
    </div>
    <?php
    require get_template_directory() . '/inc/common-sections/shop-buttons.php';
    ?>
</div>
<script>
    jQuery(document).ready(function($) {

        var $shopButtons = jQuery('.shopButtonsContainer');

        // Stop execution if element does not exist
        if (!$shopButtons.length) {
            return;
        }

        jQuery(window).on('scroll', function() {

            var scrollTop = jQuery(window).scrollTop();
            var windowHeight = jQuery(window).height();
            var documentHeight = jQuery(document).height();

            // Trigger points
            var trigger30vh = windowHeight * 0.3;
            var triggerBottom = (documentHeight - windowHeight) * 0.95;

            if (scrollTop >= trigger30vh && scrollTop < triggerBottom) {
                $shopButtons.removeClass('translate-y-full');
            } else {
                $shopButtons.addClass('translate-y-full');
            }

        });

    });
</script>




<div id="watchVideoModal" data-modal-backdrop="static" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative w-full max-w-2xl max-h-full">
        <!-- Modal content -->
        <div class="relative shadow-sm p-4 bg-white rounded-xl">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-2">
                <h3 class="text-lg font-medium text-heading">
                    Video
                </h3>
                <button type="button" class="text-body bg-transparent hover:bg-neutral-tertiary hover:text-heading rounded-base text-sm w-9 h-9 ms-auto inline-flex justify-center items-center cursor-pointer" data-modal-hide="watchVideoModal">
                    <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18 17.94 6M18 18 6.06 6" />
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <?php
            $video = get_field('video_url', THEME_SETTINGS_ID) ?: [];
            $videourl = acf_oembed_get_url($video);
            ?>
            <?php if ($video):
                $thumbs = get_youtube_poster($videourl);
            ?>
                <div class="aspect-video video-player rounded-xl overflow-hidden [&_iframe]:h-full [&_iframe]:w-full [&_iframe]:object-cover" data-video="<?php echo esc_url($videourl); ?>">
                    <img
                        src="<?php echo esc_url($thumbs['max']); ?>"
                        alt="video"
                        class="w-full"
                        loading="lazy">

                    <!-- Play button -->
                    <span class="hidden absolute video-play top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[60px] h-[60px] bg-[rgba(0,0,0,0.7)] rounded-full shadow-[0_4px_15px_rgba(0,0,0,0.4)] sm:flex items-center justify-center p-0 text-[0]transition-all duration-300 ease-in-out hover:bg-[rgba(0,0,0,0.9)] hover:scale-[1.15]">

                        <svg

                            width="40"

                            height="40"

                            viewBox="0 0 24 24"

                            fill="white">

                            <path d="M8 5v14l11-7z" />

                        </svg>

                    </span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>


<script>
    jQuery(document).ready(function() {

        var $modal = jQuery('#watchVideoModal');

        // Guard: stop execution if modal does not exist
        if (!$modal.length) {
            return;
        }

        var $iframe = $modal.find('iframe');
        var originalSrc = $iframe.attr('src');

        // MODAL OPEN → autoplay video
        jQuery(document).on('click', '[data-modal-toggle="watchVideoModal"]', function() {

            if (!$iframe.length) return;

            // Add autoplay if not already present
            var autoplaySrc = originalSrc;

            if (autoplaySrc.indexOf('autoplay=1') === -1) {
                autoplaySrc += (autoplaySrc.indexOf('?') > -1 ? '&' : '?') + 'autoplay=1';
            }

            $iframe.attr('src', autoplaySrc);
        });

        // MODAL CLOSE → stop video
        jQuery(document).on('click', '[data-modal-hide="watchVideoModal"]', function() {

            if (!$iframe.length) return;

            // Stop video by resetting src
            $iframe.attr('src', '');
            $iframe.attr('src', originalSrc);
        });

    });
</script>



<footer class="luxuriousFooter relative">

    <?php
    $footer = get_field('footer', THEME_SETTINGS_ID) ?: [];
    $footer_bg = $footer['footer_background'] ?? null;
    ?>

    <?php if ($footer_bg): ?>
        <?php echo wp_get_attachment_image(
            $footer_bg['ID'],
            'full',
            false,
            [
                'class' => 'z-0 absolute inset-0 top-0 bottom-0 w-full h-full object-cover object-center opacity-8',
                'alt'   => esc_attr($footer_bg['alt'] ?: 'Footer Background'),
            ]
        ); ?>
    <?php endif; ?>

    <div class="relative z-10 text-(--phthalo-green) bg-[rgba(227,161,41,0.05)]">
        <div class="container">
            <div class="lg:pt-20 lg:py-15 py-10 border-b border-b-[rgba(227,161,41,0.15)] lg:border-b-[rgba(233,235,240,0.5)]">
                <div class="flex flex-col items-center lg:flex-row lg:justify-between justify-center lg:space-y-0 space-y-10 lg:space-x-10">

                    <!-- Footer Logo -->
                    <div class="w-full lg:w-auto">
                        <?php
                        $logo = get_field('site_logo', THEME_SETTINGS_ID);
                        ?>
                        <?php if ($logo): ?>
                            <a href="<?php echo esc_url(site_url()); ?>"
                                class="flex items-center max-w-[150px] mx-auto lg:mx-0">
                                <?php echo wp_get_attachment_image(
                                    $logo['ID'],
                                    'full',
                                    false,
                                    [
                                        'class' => 'w-full h-auto object-contain footerLogo',
                                        'alt'   => esc_attr(get_bloginfo('name')),
                                    ]
                                ); ?>
                            </a>
                        <?php endif; ?>
                    </div>

                    <!-- Customer Benefits -->
                    <?php
                    $customer_benefits = $footer['customer_benefits'] ?? [];

                    $items = [
                        [
                            'icon'  => $customer_benefits['icon_1'] ?? null,
                            'title' => $customer_benefits['short_title_1'] ?? '',
                        ],
                        [
                            'icon'  => $customer_benefits['icon_2'] ?? null,
                            'title' => $customer_benefits['short_title_2'] ?? '',
                        ],
                        [
                            'icon'  => $customer_benefits['icon_3'] ?? null,
                            'title' => $customer_benefits['short_title_3'] ?? '',
                        ],
                    ];

                    $has_items = false;
                    foreach ($items as $item) {
                        if ($item['icon'] || $item['title']) {
                            $has_items = true;
                            break;
                        }
                    }
                    ?>

                    <?php if ($has_items): ?>
                        <div class="max-w-52 sm:max-w-full w-full lg:w-[calc(100%-200px)] flex flex-col sm:items-center sm:flex-row lg:justify-end justify-between sm:space-x-10 lg:space-x-20 sm:space-y-0 space-y-7.5">

                            <?php foreach ($items as $item): ?>
                                <?php if ($item['icon'] || $item['title']): ?>
                                    <div class="flex items-center space-x-2.5 lg:space-x-5">

                                        <?php if ($item['icon']): ?>
                                            <div class="xl:max-w-16 max-w-9">
                                                <?php echo wp_get_attachment_image(
                                                    $item['icon']['ID'],
                                                    'full',
                                                    false,
                                                    [
                                                        'class' => 'w-full h-auto object-contain',
                                                        'alt'   => esc_attr($item['icon']['alt'] ?: ''),
                                                    ]
                                                ); ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php if ($item['title']): ?>
                                            <h4 class="text-(--phthalo-green) font-normal uppercase text-[15px] leading-[21px] tracking-[0.32px] max-w-[162px]">
                                                <?php echo esc_html($item['title']); ?>
                                            </h4>
                                        <?php endif; ?>

                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>

                        </div>
                    <?php endif; ?>

                </div>
            </div>


            <?php
            $footer           = get_field('footer', THEME_SETTINGS_ID) ?: [];
            $newsletter_part  = $footer['newsletter_part'] ?? [];

            $title_1 = $newsletter_part['title_1'] ?? '';
            $desc_1  = $newsletter_part['description_1'] ?? '';

            $title_2 = $newsletter_part['title_2'] ?? '';
            $desc_2  = $newsletter_part['description_2'] ?? '';

            $title_3 = $newsletter_part['title_3'] ?? '';
            $desc_3  = $newsletter_part['description_3'] ?? '';

            $has_content = $title_1 || $desc_1 || $title_2 || $desc_2 || $title_3 || $desc_3;
            ?>

            <?php if ($has_content): ?>
                <div class="text-(--phthalo-green) lg:py-15 py-10 flex flex-col md:flex-row md:justify-between md:space-y-0 space-y-10 md:space-x-25">

                    <!-- Newsletter -->
                    <?php if ($title_1 || $desc_1): ?>
                        <div class="md:max-w-[330px] w-full">
                            <?php if ($title_1): ?>
                                <h2 class="font-normal text-[21px] tracking-[0.32px] mb-4 md:mb-6 leading-[21px]">
                                    <?php echo esc_html($title_1); ?>
                                </h2>
                            <?php endif; ?>

                            <?php if ($desc_1): ?>
                                <div class="md:space-y-1.5 space-y-1 text-[12px] md:text-sm font-normal leading-[21px] [&_a]:hover:underline [&_a]:duration-400 [&_a]:inline-block">
                                    <?php echo esc_html($desc_1); ?>
                                </div>
                            <?php endif; ?>

                            <!-- Newsletter form (static, as-is) -->
                            <div class="mt-4 md:mt-6">
                                <div id="newsletterForm" class="relative">
                                    <?php echo do_shortcode('[forminator_form id="502"]'); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Locations -->
                    <div class="w-full flex md:justify-end justify-between space-x-7.5 lg:space-x-48">

                        <?php if ($title_2 || $desc_2): ?>
                            <div class="max-w-[221px] shrink basis-full sm:min-w-40">
                                <?php if ($title_2): ?>
                                    <h2 class="font-normal text-[21px] tracking-[0.32px] mb-4 md:mb-6 leading-[21px]">
                                        <?php echo esc_html($title_2); ?>
                                    </h2>
                                <?php endif; ?>

                                <?php if ($desc_2): ?>
                                    <div class="md:space-y-1.5 space-y-1 text-[12px] md:text-sm font-normal leading-[21px] [&_a]:hover:underline [&_a]:duration-400 [&_a]:inline-block">
                                        <?php echo wp_kses_post($desc_2); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($title_3 || $desc_3): ?>
                            <div class="max-w-[221px] shrink basis-full sm:min-w-40">
                                <?php if ($title_3): ?>
                                    <h2 class="font-normal text-[21px] tracking-[0.32px] mb-4 md:mb-6 leading-[21px]">
                                        <?php echo esc_html($title_3); ?>
                                    </h2>
                                <?php endif; ?>

                                <?php if ($desc_3): ?>
                                    <div class="md:space-y-1.5 space-y-1 text-[12px] md:text-sm font-normal leading-[21px] [&_a]:hover:underline [&_a]:duration-400 [&_a]:inline-block">
                                        <?php echo wp_kses_post($desc_3); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            <?php endif; ?>

        </div>

        <div class="bg-[rgba(227,208,210,0.4)] lg:py-7 py-4">
            <div class="container">
                <div class="flex justify-center flex-col-reverse space-y-5 space-y-reverse md:space-y-0 md:flex-row md:justify-between items-center">

                    <?php
                    $footer = get_field('footer', THEME_SETTINGS_ID) ?: [];
                    $copyright = $footer['copyright_text'] ?? null;
                    ?>

                    <?php if ($copyright): ?>
                        <p class="uppercase font-medium text-[13px] text-(--phthalo-green) leading-[100%] opacity-40 text-center md:text-left">
                            <?php echo esc_html($copyright); ?>
                        </p>
                    <?php endif; ?>



                    <div class="flex items-center justify-center">
                        <div class="flex items-center space-x-4">
                            <?php
                            if (!empty($footer_social_area)) {
                                foreach ($footer_social_area as $social) :
                            ?>
                                    <a href="<?php echo esc_attr($social['social_url']); ?>"
                                        target="_blank"
                                        class="h-6 w-6 flex items-center justify-center text-(--phthalo-green) hover:opacity-100 transition duration-400">
                                        <?php echo wp_get_attachment_image($social['social_icon'], 'full', false, [
                                            'class' => 'w-full h-auto object-contain',
                                            'alt' => 'Social Icon'
                                        ]);
                                        ?>
                                    </a>

                            <?php endforeach;
                            }

                            ?>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>
</footer><!-- #colophon -->

</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>