(function ($) {
    'use strict';
    const ajaxUrl = wooAjax.ajax_url;
    const wcAjax  = wooAjax.wc_ajax_url;
    const checkoutPage  = wooAjax.checkout_url;
    const productId = wooAjax.product_id || null;
    if (typeof wooAjax === 'undefined') return;

        // 🔒 Guard
        if (!$('.reviewSliderWrapper').length) return;

        $('.reviewSliderWrapper').each(function() {

            const $wrapper = $(this);
            const $slider = $wrapper.find('.reviewSlider');
            const $slides = $slider.find('.sliderItem');
            const $progressBar = $wrapper.find('.progressBar');

            const totalSlides = $slides.length;
            let currentIndex = 0;
            let autoSlide;
            let startX = 0;
            let isDragging = false;

            // ============================
            // Single slide
            // ============================
            if (totalSlides <= 1) {
                $progressBar.css('width', '100%');
                return;
            }

            // ============================
            // Update Slider
            // ============================
            function updateSlider(index) {
                currentIndex = index;
                $slider.css('transform', `translateX(${-index * 100}%)`);

                const progress = ((index + 1) / totalSlides) * 100;
                $progressBar.css('width', `${progress}%`);
            }

            // ============================
            // Auto Slide
            // ============================
            function startAutoSlide() {
                autoSlide = setInterval(() => {
                    currentIndex = (currentIndex + 1) % totalSlides;
                    updateSlider(currentIndex);
                }, 4000);
            }

            function stopAutoSlide() {
                clearInterval(autoSlide);
            }

            // ============================
            // POINTER EVENTS (desktop + mobile)
            // ============================
            $slider.on('pointerdown', function(e) {
                stopAutoSlide();
                startX = e.clientX;
                isDragging = true;
                $slider.addClass('cursor-grabbing');
            });

            $(document).on('pointerup', function(e) {
                if (!isDragging) return;

                const diff = e.clientX - startX;
                isDragging = false;
                $slider.removeClass('cursor-grabbing');

                if (Math.abs(diff) > 50) {
                    if (diff < 0 && currentIndex < totalSlides - 1) currentIndex++;
                    if (diff > 0 && currentIndex > 0) currentIndex--;
                    updateSlider(currentIndex);
                }

                startAutoSlide();
            });

            // ============================
            // TOUCH FALLBACK (older iOS)
            // ============================
            $slider.on('touchstart', function(e) {
                stopAutoSlide();
                startX = e.originalEvent.touches[0].clientX;
            });

            $slider.on('touchend', function(e) {
                const endX = e.originalEvent.changedTouches[0].clientX;
                const diff = endX - startX;

                if (Math.abs(diff) > 50) {
                    if (diff < 0 && currentIndex < totalSlides - 1) currentIndex++;
                    if (diff > 0 && currentIndex > 0) currentIndex--;
                    updateSlider(currentIndex);
                }

                startAutoSlide();
            });

            // ============================
            // Init
            // ============================
            updateSlider(0);
            startAutoSlide();

        });

  
 

  $('input[name="variation_id"]').on('change', function(){

        const $label = $(this).next('label');
        const regular = $label.data('regular');
        const sale = $label.data('sale');

        const $regularBox = $('.regular-price').closest('div');
        const $regularSpan = $('.regular-price');
        const $saleSpan = $('.sale-price');

        if (regular && sale && regular != sale) {
            // Has sale
            $regularSpan.text(regular);
            $saleSpan.text(sale);
            $regularBox.show();
        } else {
            // No sale
            $saleSpan.text(sale || regular);
            $regularBox.hide();
        }
    });
        const $navBtns = $(".navSlider .navBtn");
        const $mainItems = $(".mainSlider .mainSliderItem");
        const $modal = $("#shopModal");
        const $modalSlider = $(".modalSlider");
        const $modalItems = $(".modalSlider .modalSliderItem");
        const $previewBtn = $(".previewBtn");
        const $nextBtn = $(".nextBtn");

        let currentIndex = 0;
        let modalIndex = 0;

        // ===================================================
        // 🎯 Main Slider (NO scroll, NO mobile logic)
        // ===================================================
        function activateSlide(index) {
            currentIndex = index;

            $mainItems
                .removeClass("active")
                .addClass("hidden")
                .eq(index)
                .removeClass("hidden")
                .addClass("active");

            $navBtns.removeClass("active").eq(index).addClass("active");
        }

        // Initial state
        activateSlide(0);

        // Nav click
        $navBtns.on("click", function() {
            activateSlide($(this).index());
        });

        // ===================================================
        // 🧭 Modal Logic (UNCHANGED)
        // ===================================================
        $mainItems.on("click", function() {
            modalIndex = $(this).index();
            openModal(modalIndex);
        });

        function openModal(index) {
            $modal.removeClass("hidden").addClass("flex");
            updateModalSlider(index);
        }

        function updateModalSlider(index) {
            modalIndex = Math.max(0, Math.min(index, $modalItems.length - 1));
            $modalSlider.css({
                transform: `translateX(${-modalIndex * 100}%)`,
                transition: "transform 0.4s ease"
            });

            $previewBtn.toggleClass("opacity-40 pointer-events-none", modalIndex === 0);
            $nextBtn.toggleClass("opacity-40 pointer-events-none", modalIndex === $modalItems.length - 1);
        }

        $previewBtn.on("click", function() {
            if (modalIndex > 0) updateModalSlider(--modalIndex);
        });

        $nextBtn.on("click", function() {
            if (modalIndex < $modalItems.length - 1) updateModalSlider(++modalIndex);
        });

        // Modal swipe
        let startX = 0;
        $modal.on("touchstart", e => startX = e.originalEvent.touches[0].pageX);
        $modal.on("touchend", e => {
            const diff = e.originalEvent.changedTouches[0].pageX - startX;
            if (Math.abs(diff) > 50) {
                if (diff < 0 && modalIndex < $modalItems.length - 1) modalIndex++;
                if (diff > 0 && modalIndex > 0) modalIndex--;
                updateModalSlider(modalIndex);
            }
        });

        // Close modal
        $modal.find("[data-modal-hide]").on("click", function() {
            $modal.addClass("hidden").removeClass("flex");
        });

 

        // HARD GUARD
$('.addToCart').on('click', function (e) {
    e.preventDefault();
    addToCart(false);
});

$('.wcProductBuy').on('click', function (e) {
    e.preventDefault();
    addToCart(true);
});
function addToCart(isBuyNow = false) {

    const $selected = $('input[name="variation_id"]:checked');
    if (!$selected.length) {
        alert('Please select a size');
        return;
    }

    const variation_id = $selected.val();
    const size = $selected.data('attribute_pa_size');
    const qty = $('input[name="quantity"]').val() || 1;

    const button = isBuyNow ? $('.wcProductBuy')[0] : $('.addToCart')[0];
    const cart = document.querySelector('.cart-target');
    const icon = button ? button.querySelector('.cart-icon') : null;

    $.ajax({
        type: 'POST',
        url: wc_add_to_cart_params.ajax_url,
        data: {
            action: 'woocommerce_custom_add_to_cart',
            product_id: productId,
            variation_id: variation_id,
            quantity: qty,
            attribute_pa_size: size,
            buy_now: isBuyNow ? 1 : 0
        },
        success: function (response) {

            // ❌ Woo error
            if (response?.error && response?.product_url) {
                window.location = response.product_url;
                return;
            }

            // ✅ BUY NOW → redirect immediately
            if (isBuyNow) {
                window.location.href = checkoutPage;
                return;
            }

            // ✅ ADD TO CART → animation + fragment refresh
            if (!icon || !cart) return;

            const iconRect = icon.getBoundingClientRect();
            const startX = iconRect.left + iconRect.width / 2;
            const startY = iconRect.top + iconRect.height / 2;

            const cartRect = cart.getBoundingClientRect();
            const endX = cartRect.left + cartRect.width / 2;
            const endY = cartRect.top + cartRect.height / 2;

            const fly = document.createElement('span');
            fly.className = 'fly-to-cart';
            fly.textContent = qty;
            document.body.appendChild(fly);

            fly.style.left = `${startX}px`;
            fly.style.top = `${startY}px`;
            const deltaX = endX - startX;
             const deltaY = endY - startY;
            fly.animate([
                { transform: 'translate(0,0)' },
                { transform: `translate(0, ${deltaY * 0.6}px)` },
                { transform: `translate(${deltaX * 0.4}px, ${deltaY * 0.8}px)` },
                { transform: `translate(${deltaX}px, ${deltaY}px) scale(0.4)` }
            ], {
                duration: 2000,
                easing: 'cubic-bezier(0.65, 0, 0.35, 1)',
                fill: 'forwards'
            });

            setTimeout(() => {
                fly.remove();
                cart.classList.add('cart-shake');
                setTimeout(() => cart.classList.remove('cart-shake'), 400);

                // 🔄 Woo fragment refresh
                $(document.body).trigger('added_to_cart', [
                    response.fragments,
                    response.cart_hash,
                    $('.addToCart')
                ]);
            }, 2000);
        }
    });
}

        // $('.wcProductBuy').on('click', function(e) {
        // });
        // $('.addToCart').on('click', function(e) {
        //     e.preventDefault();

        //     const button = this;
        //     const cart = document.querySelector('.cart-target');

        //     // 👉 Find the cart icon INSIDE the button (start point)
        //  const icon = button.querySelector('.cart-icon');

        // const variation_id = $('input[name="variation_id"]:checked').val();
        //   const $selected = $('input[name="variation_id"]:checked');

        // if (!variation_id) {
        //     alert('Please select a size');
        //     return;
        // }
        // const size = $selected.data('attribute_pa_size');
        // const qty = $('input[name="quantity"]').val() || 1;
        // $.ajax({
        //     type: 'POST',
        //     url: wc_add_to_cart_params.ajax_url,
        //     data: {
        //         action: 'woocommerce_custom_add_to_cart',
        //         product_id: productId,
        //         variation_id: variation_id,
        //         quantity: qty,
        //         attribute_pa_size: size
        //     },
        //     success: function(response) {

        //         if (response.error && response.product_url) {
        //             window.location = response.product_url;
        //             return;
        //         }

        //      if (!response?.data?.message) {

        //         //animation

        //     /* ---------------------------------
        //        START POSITION (icon inside button)
        //     --------------------------------- */
        //     const iconRect = icon.getBoundingClientRect();
        //     const startX = iconRect.left + iconRect.width / 2;
        //     const startY = iconRect.top + iconRect.height / 2;

        //     /* ---------------------------------
        //        END POSITION (header cart icon)
        //     --------------------------------- */
        //     const cartRect = cart.getBoundingClientRect();
        //     const endX = cartRect.left + cartRect.width / 2;
        //     const endY = cartRect.top + cartRect.height / 2;

        //     /* ---------------------------------
        //        CREATE FLY ELEMENT (NUMBER ONLY)
        //     --------------------------------- */
        //     const fly = document.createElement('span');
        //     fly.className = 'fly-to-cart';
        //     fly.textContent = qty;

        //     document.body.appendChild(fly);

        //     // Place exactly on top of the button icon
        //     fly.style.left = `${startX}px`;
        //     fly.style.top = `${startY}px`;

        //     /* ---------------------------------
        //        CURVED PATH (your working logic)
        //     --------------------------------- */
        //     const deltaX = endX - startX;
        //     const deltaY = endY - startY;

        //     fly.animate([{
        //             transform: 'translate(0, 0)'
        //         },

        //         // Move straight up
        //         {
        //             transform: `translate(0, ${deltaY * 0.6}px)`
        //         },

        //         // Curve transition
        //         {
        //             transform: `translate(${deltaX * 0.4}px, ${deltaY * 0.8}px)`
        //         },

        //         // Final position into cart
        //         {
        //             transform: `translate(${deltaX}px, ${deltaY}px) scale(0.4)`
        //         }
        //     ], {
        //         duration: 2000,
        //         easing: 'cubic-bezier(0.65, 0, 0.35, 1)',
        //         fill: 'forwards'
        //     });

        //     /* ---------------------------------
        //        CLEANUP + CART SHAKE
        //     --------------------------------- */
        //     setTimeout(() => {
        //         fly.remove();

        //         cart.classList.add('cart-shake');
        //         setTimeout(() => {
        //             cart.classList.remove('cart-shake');
        //         }, 400);
        //         $(document.body).trigger('added_to_cart', [
        //             response.fragments,
        //             response.cart_hash,
        //             $('.addToCart')
        //         ]);
        //     }, 2000);
        //      }
        //      else{
        //         $('.woocommerce-invalid').html('<p>'+response.data.message+'</p>')
        //      }

        //     }
        // });
        
           

        // });
        //qty
         $(document).on('click', '.plus, .minus', function (e) {
        e.preventDefault();

        const $btn = $(this);
        const $wrap = $btn.closest('.qty-sec');
        const $input = $wrap.find('input[name="quantity"]');
        if (!$input.length) return;

        let val = parseInt($input.val(), 10);
        if (isNaN(val) || val < 1) val = 1;

        const min = parseInt($input.attr('min'), 10) || 1;
        const max = parseInt($input.attr('max'), 10);

        if ($btn.hasClass('plus')) {
            val++;
            if (!isNaN(max) && val > max) val = max;
        } else {
            val--;
            if (val < min) val = min;
        }

        $input.val(val).trigger('change');
    });
    
  const $first = $('input[name="variation_id"]').first();
    if ($first.length) {
        $first.prop('checked', true).trigger('change');
    }
  

})(jQuery);