<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Luxurious_Skincare_Encoder_IT
 */

get_header();
?>

<main id="primary" class="site-main overflow-hidden relative">
	<?php require get_template_directory() . '/inc/common-sections/banner-ellipse.php'; ?>
	<section class="section-padding md:pt-[145px]! pt-[130px]! relative error-404 not-found">
		<div class="container">
			<?php require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php'; ?>
		</div>
		<div class="container">
			<div class="max-w-[700px] mx-auto text-center space-y-[45px] md:space-y-15">
				<div class="space-y-2.5">
					<h1 class="font-normal text-2xl lg:text-[46px] leading-[140%] lg:leading-[129%]">
						<?php esc_html_e('Oops!', 'luxurious-skincare-encoder-it'); ?>
						<br>
						<?php esc_html_e('That page can&rsquo;t be found.', 'luxurious-skincare-encoder-it'); ?>
					</h1>
					<div class="font-medium text-[15px] leading-[180%] max-w-[400px] mx-auto">
						<?php esc_html_e('It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'luxurious-skincare-encoder-it'); ?>
					</div>
				</div>
				<div class="flex justify-center items-center">
					<a href="<?php echo site_url(); ?>" class="btn-primary w-auto">
						<span class="relative z-10">Back to Home</span>
					</a>
				</div>
			</div>
		</div>

	</section><!-- .error-404 -->

</main><!-- #main -->

<?php
get_footer();
