<?php
/**
 * Plugin list of WPMU DEV for the cross-sell sub-module. Includes Free and Pro plugins.
 *
 * @link    https://wpmudev.com/
 * @since   1.0.0
 *
 * @author  WPMUDEV (https://wpmudev.com)
 * @package WPMUDEV\Plugin_Cross_Sell
 *
 * @copyright (c) 2025, WPMU DEV (http://wpmudev.com)
 */

// List of plugins

return array(
	'wp-smushit'       => array(
		'slug'            => 'wp-smushit',
		'path'            => 'wp-smushit/wp-smush.php',
		'url'             => 'https://wordpress.org/plugins/wp-smushit/',
		'utm_source'      => 'smush',
		'utm_campaign'    => 'cross-sell_plugin_smush',
		'admin_url_page'  => 'smush',
		'logo'            => 'wp-smushit.png',
		'title'           => __( 'Smush', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'Image Optimization', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'Smush image size down to size for faster page loading.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.8,
		'rating_count'    => '6,017+ reviews',
		'active_installs' => '1,200,000+',
	),
	'forminator'  => array(
		'slug'            => 'forminator',
		'path'            => 'forminator/forminator.php',
		'url'             => 'https://wordpress.org/plugins/forminator/',
		'utm_source'      => 'forminator',
		'utm_campaign'    => 'cross-sell_plugin_forminator',
		'admin_url_page'  => 'forminator',
		'logo'            => 'forminator.png',
		'title'           => __( 'Forminator', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'Forms & Surveys', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'One plugin for every form your site could ever need.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.8,
		'rating_count'    => '1,967+ reviews',
		'active_installs' => '600,000+',
	),
	'hummingbird-performance' => array(
		'slug'            => 'hummingbird-performance',
		'path'            => 'hummingbird-performance/wp-hummingbird.php',
		'url'             => 'https://wordpress.org/plugins/hummingbird-performance/',
		'utm_source'      => 'hummingbird',
		'utm_campaign'    => 'cross-sell_plugin_hummingbird',
		'admin_url_page'  => 'wphb',
		'logo'            => 'hummingbird-performance.png',
		'title'           => __( 'Hummingbird', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'Site performance', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'For sites that load in one flap of a hummingbird’s wing. ', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.7,
		'rating_count'    => '1,483+ reviews',
		'active_installs' => '90,000+',
	),
	'defender-security'    => array(
		'slug'            => 'defender-security',
		'path'            => 'defender-security/wp-defender.php',
		'url'             => 'https://wordpress.org/plugins/defender-security/',
		'utm_source'      => 'defender',
		'utm_campaign'    => 'cross-sell_plugin_defender',
		'admin_url_page'  => 'wp-defender',
		'logo'            => 'defender-security.png',
		'title'           => __( 'Defender', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'Security', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'Automated and reliable WordPress security in a matter of clicks.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.8,
		'rating_count'    => '318+ reviews',
		'active_installs' => '90,000+',
	),
	'wordpress-popup'      => array(
		'slug'            => 'wordpress-popup',
		'path'            => 'wordpress-popup/popover.php',
		'url'             => 'https://wordpress.org/plugins/wordpress-popup/',
		'utm_source'      => 'hustle',
		'utm_campaign'    => 'cross-sell_plugin_hustle',
		'admin_url_page'  => 'hustle',
		'logo'            => 'wordpress-popup.png',
		'title'           => __( 'Hustle', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'Marketing tools', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'Opt-ins so good, you’ll want to subscribe to yourself.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.4,
		'rating_count'    => '852+ reviews',
		'active_installs' => '100k +',
	),
	'broken-link-checker'         => array(
		'slug'            => 'broken-link-checker',
		'path'            => 'broken-link-checker/broken-link-checker.php',
		'url'             => 'https://wordpress.org/plugins/broken-link-checker/',
		'utm_source'      => 'blc',
		'utm_campaign'    => 'cross-sell_plugin_blc',
		'admin_url_page'  => 'blc_dash',
		'logo'            => 'broken-link-checker.png',
		'title'           => __( 'BLC', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'Broken Link Checker', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'Check posts, pages & content for broken links to improve SEO.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 3.8,
		'rating_count'    => '',
		'active_installs' => '600k +',
	),
	'smartcrawl-seo'  => array(
		'slug'            => 'smartcrawl-seo',
		'path'            => 'smartcrawl-seo/wpmu-dev-seo.php',
		'url'             => 'https://wordpress.org/plugins/smartcrawl-seo/',
		'utm_source'      => 'smartcrawl',
		'utm_campaign'    => 'cross-sell_plugin_smartcrawl',
		'admin_url_page'  => 'wds_wizard',
		'logo'            => 'smartcrawl-seo.png',
		'title'           => __( 'SmartCrawl', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'SEO', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'Take the mystery out of optimizing your site. Rank higher and better.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.8,
		'rating_count'    => '',
		'active_installs' => '20k +',
	),
	'branda-white-labeling'      => array(
		'slug'            => 'branda-white-labeling',
		'path'            => 'branda-white-labeling/ultimate-branding.php',
		'url'             => 'https://wordpress.org/plugins/branda-white-labeling/',
		'utm_source'      => 'branda',
		'utm_campaign'    => 'cross-sell_plugin_branda',
		'admin_url_page'  => 'branding',
		'logo'            => 'branda-white-labeling.png',
		'title'           => __( 'Branda', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'White label WordPress', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'Rebrand, customize, and white label WordPress without code.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.5,
		'rating_count'    => '',
		'active_installs' => '20k +',
	),
	'beehive-analytics'     => array(
		'slug'            => 'beehive-analytics',
		'path'            => 'beehive-analytics/beehive-analytics.php',
		'url'             => 'https://wordpress.org/plugins/beehive-analytics/',
		'utm_source'      => 'beehive',
		'utm_campaign'    => 'cross-sell_plugin_beehive',
		'admin_url_page'  => 'beehive',
		'logo'            => 'beehive-analytics.png',
		'title'           => __( 'Beehive', 'plugin-cross-sell-textdomain' ),
		'label'           => __( 'Customize analytics', 'plugin-cross-sell-textdomain' ),
		'description'     => __( 'Customizable Google Analytics dashboards, statistics, and reports.', 'plugin-cross-sell-textdomain' ),
		'features'        => array(),
		'installed'       => false,
		'active'          => false,
		'rating'          => 4.8,
		'rating_count'    => '',
		'active_installs' => '30k +',
	),
);
